/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.EventInformation;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EventInformationStaxUnmarshaller
implements Unmarshaller<EventInformation, StaxUnmarshallerContext> {
    private static EventInformationStaxUnmarshaller instance;

    @Override
    public EventInformation unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventInformation eventInformation = new EventInformation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return eventInformation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("instanceId", targetDepth)) {
                    eventInformation.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventSubType", targetDepth)) {
                    eventInformation.setEventSubType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("eventDescription", targetDepth)) continue;
                eventInformation.setEventDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return eventInformation;
    }

    public static EventInformationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EventInformationStaxUnmarshaller();
        }
        return instance;
    }
}

