/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.wafv2.model.HTTPRequest;
import java.util.List;

@SdkInternalApi
public class HTTPRequestMarshaller {
    private static final MarshallingInfo<String> CLIENTIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientIP").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("URI").build();
    private static final MarshallingInfo<String> METHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Method").build();
    private static final MarshallingInfo<String> HTTPVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HTTPVersion").build();
    private static final MarshallingInfo<List> HEADERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Headers").build();
    private static final HTTPRequestMarshaller instance = new HTTPRequestMarshaller();

    public static HTTPRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(HTTPRequest hTTPRequest, ProtocolMarshaller protocolMarshaller) {
        if (hTTPRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hTTPRequest.getClientIP(), CLIENTIP_BINDING);
            protocolMarshaller.marshall(hTTPRequest.getCountry(), COUNTRY_BINDING);
            protocolMarshaller.marshall(hTTPRequest.getURI(), URI_BINDING);
            protocolMarshaller.marshall(hTTPRequest.getMethod(), METHOD_BINDING);
            protocolMarshaller.marshall(hTTPRequest.getHTTPVersion(), HTTPVERSION_BINDING);
            protocolMarshaller.marshall(hTTPRequest.getHeaders(), HEADERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

