/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wafv2.model.DefaultAction;
import com.amazonaws.services.wafv2.model.Rule;
import com.amazonaws.services.wafv2.model.Scope;
import com.amazonaws.services.wafv2.model.Tag;
import com.amazonaws.services.wafv2.model.VisibilityConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateWebACLRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String scope;
    private DefaultAction defaultAction;
    private String description;
    private List<Rule> rules;
    private VisibilityConfig visibilityConfig;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateWebACLRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public CreateWebACLRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public CreateWebACLRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public void setDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public DefaultAction getDefaultAction() {
        return this.defaultAction;
    }

    public CreateWebACLRequest withDefaultAction(DefaultAction defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateWebACLRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public CreateWebACLRequest withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CreateWebACLRequest withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.visibilityConfig = visibilityConfig;
    }

    public VisibilityConfig getVisibilityConfig() {
        return this.visibilityConfig;
    }

    public CreateWebACLRequest withVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.setVisibilityConfig(visibilityConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateWebACLRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateWebACLRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getVisibilityConfig() != null) {
            sb.append("VisibilityConfig: ").append(this.getVisibilityConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebACLRequest)) {
            return false;
        }
        CreateWebACLRequest other = (CreateWebACLRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        if (other.getDefaultAction() != null && !other.getDefaultAction().equals(this.getDefaultAction())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getVisibilityConfig() == null ^ this.getVisibilityConfig() == null) {
            return false;
        }
        if (other.getVisibilityConfig() != null && !other.getVisibilityConfig().equals(this.getVisibilityConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityConfig() == null ? 0 : this.getVisibilityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateWebACLRequest clone() {
        return (CreateWebACLRequest)super.clone();
    }
}

