/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wafv2.model.IPAddressVersion;
import com.amazonaws.services.wafv2.model.Scope;
import com.amazonaws.services.wafv2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIPSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String scope;
    private String description;
    private String iPAddressVersion;
    private List<String> addresses;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateIPSetRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public CreateIPSetRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public CreateIPSetRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateIPSetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIPAddressVersion(String iPAddressVersion) {
        this.iPAddressVersion = iPAddressVersion;
    }

    public String getIPAddressVersion() {
        return this.iPAddressVersion;
    }

    public CreateIPSetRequest withIPAddressVersion(String iPAddressVersion) {
        this.setIPAddressVersion(iPAddressVersion);
        return this;
    }

    public CreateIPSetRequest withIPAddressVersion(IPAddressVersion iPAddressVersion) {
        this.iPAddressVersion = iPAddressVersion.toString();
        return this;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Collection<String> addresses) {
        if (addresses == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new ArrayList<String>(addresses);
    }

    public CreateIPSetRequest withAddresses(String ... addresses) {
        if (this.addresses == null) {
            this.setAddresses(new ArrayList<String>(addresses.length));
        }
        for (String ele : addresses) {
            this.addresses.add(ele);
        }
        return this;
    }

    public CreateIPSetRequest withAddresses(Collection<String> addresses) {
        this.setAddresses(addresses);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateIPSetRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateIPSetRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getIPAddressVersion() != null) {
            sb.append("IPAddressVersion: ").append(this.getIPAddressVersion()).append(",");
        }
        if (this.getAddresses() != null) {
            sb.append("Addresses: ").append(this.getAddresses()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIPSetRequest)) {
            return false;
        }
        CreateIPSetRequest other = (CreateIPSetRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIPAddressVersion() == null ^ this.getIPAddressVersion() == null) {
            return false;
        }
        if (other.getIPAddressVersion() != null && !other.getIPAddressVersion().equals(this.getIPAddressVersion())) {
            return false;
        }
        if (other.getAddresses() == null ^ this.getAddresses() == null) {
            return false;
        }
        if (other.getAddresses() != null && !other.getAddresses().equals(this.getAddresses())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIPAddressVersion() == null ? 0 : this.getIPAddressVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAddresses() == null ? 0 : this.getAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateIPSetRequest clone() {
        return (CreateIPSetRequest)super.clone();
    }
}

