/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wafv2.model.Rule;
import com.amazonaws.services.wafv2.model.Scope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckCapacityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String scope;
    private List<Rule> rules;

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public CheckCapacityRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public CheckCapacityRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public CheckCapacityRequest withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CheckCapacityRequest withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckCapacityRequest)) {
            return false;
        }
        CheckCapacityRequest other = (CheckCapacityRequest)obj;
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    @Override
    public CheckCapacityRequest clone() {
        return (CheckCapacityRequest)super.clone();
    }
}

