/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.timestreamwrite.model.Database;
import java.util.Date;

@SdkInternalApi
public class DatabaseMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<Long> TABLECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableCount").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final DatabaseMarshaller instance = new DatabaseMarshaller();

    public static DatabaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(Database database, ProtocolMarshaller protocolMarshaller) {
        if (database == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(database.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(database.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(database.getTableCount(), TABLECOUNT_BINDING);
            protocolMarshaller.marshall(database.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(database.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(database.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

