/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamwrite.model.Dimension;
import com.amazonaws.services.timestreamwrite.model.MeasureValueType;
import com.amazonaws.services.timestreamwrite.model.TimeUnit;
import com.amazonaws.services.timestreamwrite.model.transform.RecordMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Record
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Dimension> dimensions;
    private String measureName;
    private String measureValue;
    private String measureValueType;
    private String time;
    private String timeUnit;

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<Dimension>(dimensions);
    }

    public Record withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public Record withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setMeasureName(String measureName) {
        this.measureName = measureName;
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public Record withMeasureName(String measureName) {
        this.setMeasureName(measureName);
        return this;
    }

    public void setMeasureValue(String measureValue) {
        this.measureValue = measureValue;
    }

    public String getMeasureValue() {
        return this.measureValue;
    }

    public Record withMeasureValue(String measureValue) {
        this.setMeasureValue(measureValue);
        return this;
    }

    public void setMeasureValueType(String measureValueType) {
        this.measureValueType = measureValueType;
    }

    public String getMeasureValueType() {
        return this.measureValueType;
    }

    public Record withMeasureValueType(String measureValueType) {
        this.setMeasureValueType(measureValueType);
        return this;
    }

    public Record withMeasureValueType(MeasureValueType measureValueType) {
        this.measureValueType = measureValueType.toString();
        return this;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getTime() {
        return this.time;
    }

    public Record withTime(String time) {
        this.setTime(time);
        return this;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public Record withTimeUnit(String timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    public Record withTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getMeasureName() != null) {
            sb.append("MeasureName: ").append(this.getMeasureName()).append(",");
        }
        if (this.getMeasureValue() != null) {
            sb.append("MeasureValue: ").append(this.getMeasureValue()).append(",");
        }
        if (this.getMeasureValueType() != null) {
            sb.append("MeasureValueType: ").append(this.getMeasureValueType()).append(",");
        }
        if (this.getTime() != null) {
            sb.append("Time: ").append(this.getTime()).append(",");
        }
        if (this.getTimeUnit() != null) {
            sb.append("TimeUnit: ").append(this.getTimeUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getMeasureName() == null ^ this.getMeasureName() == null) {
            return false;
        }
        if (other.getMeasureName() != null && !other.getMeasureName().equals(this.getMeasureName())) {
            return false;
        }
        if (other.getMeasureValue() == null ^ this.getMeasureValue() == null) {
            return false;
        }
        if (other.getMeasureValue() != null && !other.getMeasureValue().equals(this.getMeasureValue())) {
            return false;
        }
        if (other.getMeasureValueType() == null ^ this.getMeasureValueType() == null) {
            return false;
        }
        if (other.getMeasureValueType() != null && !other.getMeasureValueType().equals(this.getMeasureValueType())) {
            return false;
        }
        if (other.getTime() == null ^ this.getTime() == null) {
            return false;
        }
        if (other.getTime() != null && !other.getTime().equals(this.getTime())) {
            return false;
        }
        if (other.getTimeUnit() == null ^ this.getTimeUnit() == null) {
            return false;
        }
        return other.getTimeUnit() == null || other.getTimeUnit().equals(this.getTimeUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getMeasureName() == null ? 0 : this.getMeasureName().hashCode());
        hashCode = 31 * hashCode + (this.getMeasureValue() == null ? 0 : this.getMeasureValue().hashCode());
        hashCode = 31 * hashCode + (this.getMeasureValueType() == null ? 0 : this.getMeasureValueType().hashCode());
        hashCode = 31 * hashCode + (this.getTime() == null ? 0 : this.getTime().hashCode());
        hashCode = 31 * hashCode + (this.getTimeUnit() == null ? 0 : this.getTimeUnit().hashCode());
        return hashCode;
    }

    public Record clone() {
        try {
            return (Record)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

