/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamquery.model.Datum;
import java.util.List;

@SdkInternalApi
public class DatumMarshaller {
    private static final MarshallingInfo<String> SCALARVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScalarValue").build();
    private static final MarshallingInfo<List> TIMESERIESVALUE_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeSeriesValue").build();
    private static final MarshallingInfo<List> ARRAYVALUE_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArrayValue").build();
    private static final MarshallingInfo<StructuredPojo> ROWVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowValue").build();
    private static final MarshallingInfo<Boolean> NULLVALUE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NullValue").build();
    private static final DatumMarshaller instance = new DatumMarshaller();

    public static DatumMarshaller getInstance() {
        return instance;
    }

    public void marshall(Datum datum, ProtocolMarshaller protocolMarshaller) {
        if (datum == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(datum.getScalarValue(), SCALARVALUE_BINDING);
            protocolMarshaller.marshall(datum.getTimeSeriesValue(), TIMESERIESVALUE_BINDING);
            protocolMarshaller.marshall(datum.getArrayValue(), ARRAYVALUE_BINDING);
            protocolMarshaller.marshall(datum.getRowValue(), ROWVALUE_BINDING);
            protocolMarshaller.marshall(datum.getNullValue(), NULLVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

