/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model.transform;

import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.TimeSeriesDataPoint;
import com.amazonaws.services.timestreamquery.model.transform.RowJsonUnmarshaller;
import com.amazonaws.services.timestreamquery.model.transform.TimeSeriesDataPointJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DatumJsonUnmarshaller
implements Unmarshaller<Datum, JsonUnmarshallerContext> {
    private static DatumJsonUnmarshaller instance;

    @Override
    public Datum unmarshall(JsonUnmarshallerContext context) throws Exception {
        Datum datum = new Datum();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ScalarValue", targetDepth)) {
                    context.nextToken();
                    datum.setScalarValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TimeSeriesValue", targetDepth)) {
                    context.nextToken();
                    datum.setTimeSeriesValue(new ListUnmarshaller<TimeSeriesDataPoint>(TimeSeriesDataPointJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ArrayValue", targetDepth)) {
                    context.nextToken();
                    datum.setArrayValue(new ListUnmarshaller<Datum>(DatumJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("RowValue", targetDepth)) {
                    context.nextToken();
                    datum.setRowValue(RowJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("NullValue", targetDepth)) {
                    context.nextToken();
                    datum.setNullValue(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return datum;
    }

    public static DatumJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatumJsonUnmarshaller();
        }
        return instance;
    }
}

