/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.endpointdiscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.cache.EndpointDiscoveryCacheLoader;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQuery;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamquery.model.Endpoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmazonTimestreamQueryEndpointCacheLoader
implements EndpointDiscoveryCacheLoader<String, Map<String, String>> {
    private final AmazonTimestreamQuery client;

    public AmazonTimestreamQueryEndpointCacheLoader(AmazonTimestreamQuery client) {
        this.client = client;
    }

    @Override
    public Map<String, String> load(String key, AmazonWebServiceRequest discoveryRequest) {
        DescribeEndpointsRequest request;
        DescribeEndpointsResult response;
        List<Endpoint> endpoints;
        if (discoveryRequest == null) {
            discoveryRequest = new DescribeEndpointsRequest();
        }
        if ((endpoints = (response = this.client.describeEndpoints(request = (DescribeEndpointsRequest)discoveryRequest)).getEndpoints()) == null || endpoints.size() == 0) {
            return null;
        }
        Endpoint endpoint = endpoints.get(0);
        HashMap<String, String> endpointDetail = new HashMap<String, String>();
        endpointDetail.put("CachePeriod", String.valueOf(endpoint.getCachePeriodInMinutes()));
        endpointDetail.put("Endpoint", endpoint.getAddress());
        return endpointDetail;
    }
}

