/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.endpointdiscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryIdentifiersRefreshCache;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQuery;
import com.amazonaws.services.timestreamquery.endpointdiscovery.AmazonTimestreamQueryEndpointCacheLoader;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonTimestreamQueryEndpointCache
extends EndpointDiscoveryIdentifiersRefreshCache<String> {
    private static final Log log = LogFactory.getLog(AmazonTimestreamQueryEndpointCache.class);

    public AmazonTimestreamQueryEndpointCache(AmazonTimestreamQuery client) {
        super(new AmazonTimestreamQueryEndpointCacheLoader(client));
    }

    @Override
    public URI get(String key, AmazonWebServiceRequest discoveryRequest, boolean required, URI defaultEndpoint) {
        URI endpoint = (URI)this.cache.get(this.constructKey(key, discoveryRequest));
        if (endpoint != null) {
            return endpoint;
        }
        if (!required) {
            this.cache.put(key, defaultEndpoint);
        }
        return this.discoverEndpoint(key, discoveryRequest, required, defaultEndpoint);
    }

    @Override
    public URI put(String key, AmazonWebServiceRequest discoveryRequest, Map<String, String> endpointDetails, URI defaultEndpoint) {
        URI discoveredEndpoint = URI.create(String.format("%s://%s", defaultEndpoint.getScheme(), endpointDetails.get("Endpoint")));
        this.cache.put(key, discoveredEndpoint);
        this.loadAndScheduleEvict(key, Long.valueOf(endpointDetails.get("CachePeriod")), TimeUnit.MINUTES);
        log.debug((Object)("Cached new endpoint from service: " + discoveredEndpoint.toASCIIString()));
        log.debug((Object)("Cached endpoint TTL: " + endpointDetails.get("CachePeriod") + " minutes"));
        return discoveredEndpoint;
    }

    @Override
    public String constructKey(String key, AmazonWebServiceRequest discoveryRequest) {
        return key;
    }
}

