/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.endpointdiscovery.DefaultEndpointDiscoveryProviderChain;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryProviderChain;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQuery;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClient;

@NotThreadSafe
public final class AmazonTimestreamQueryClientBuilder
extends AwsSyncClientBuilder<AmazonTimestreamQueryClientBuilder, AmazonTimestreamQuery> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new ClientConfigurationFactory();
    private static final EndpointDiscoveryProviderChain DEFAULT_ENDPOINT_DISCOVERY_PROVIDER = new DefaultEndpointDiscoveryProviderChain();
    private boolean endpointDiscoveryEnabled = true;
    private boolean endpointDiscoveryDisabled = false;

    public static AmazonTimestreamQueryClientBuilder standard() {
        return new AmazonTimestreamQueryClientBuilder();
    }

    public static AmazonTimestreamQuery defaultClient() {
        return (AmazonTimestreamQuery)AmazonTimestreamQueryClientBuilder.standard().build();
    }

    private AmazonTimestreamQueryClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public AmazonTimestreamQueryClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    public AmazonTimestreamQueryClientBuilder disableEndpointDiscovery() {
        this.endpointDiscoveryDisabled = true;
        return this;
    }

    private boolean endpointDiscoveryEnabled() {
        Boolean endpointDiscoveryChainSetting = DEFAULT_ENDPOINT_DISCOVERY_PROVIDER.endpointDiscoveryEnabled();
        if (this.endpointDiscoveryDisabled) {
            return false;
        }
        if (this.endpointDiscoveryEnabled) {
            return true;
        }
        if (endpointDiscoveryChainSetting != null && !endpointDiscoveryChainSetting.booleanValue()) {
            return false;
        }
        if (endpointDiscoveryChainSetting != null && endpointDiscoveryChainSetting.booleanValue()) {
            return true;
        }
        return InternalConfig.Factory.getInternalConfig().endpointDiscoveryEnabled();
    }

    @Override
    protected AmazonTimestreamQuery build(AwsSyncClientParams params) {
        if (this.endpointDiscoveryEnabled() && this.getEndpoint() == null) {
            return new AmazonTimestreamQueryClient(params, true);
        }
        return new AmazonTimestreamQueryClient(params);
    }
}

