/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.endpointdiscovery.DefaultEndpointDiscoveryProviderChain;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryProviderChain;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryAsync;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryAsyncClient;

@NotThreadSafe
public final class AmazonTimestreamQueryAsyncClientBuilder
extends AwsAsyncClientBuilder<AmazonTimestreamQueryAsyncClientBuilder, AmazonTimestreamQueryAsync> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new ClientConfigurationFactory();
    private static final EndpointDiscoveryProviderChain DEFAULT_ENDPOINT_DISCOVERY_PROVIDER = new DefaultEndpointDiscoveryProviderChain();
    private boolean endpointDiscoveryEnabled = true;
    private boolean endpointDiscoveryDisabled = false;

    public static AmazonTimestreamQueryAsyncClientBuilder standard() {
        return new AmazonTimestreamQueryAsyncClientBuilder();
    }

    public static AmazonTimestreamQueryAsync defaultClient() {
        return (AmazonTimestreamQueryAsync)AmazonTimestreamQueryAsyncClientBuilder.standard().build();
    }

    private AmazonTimestreamQueryAsyncClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public AmazonTimestreamQueryAsyncClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    public AmazonTimestreamQueryAsyncClientBuilder disableEndpointDiscovery() {
        this.endpointDiscoveryDisabled = true;
        return this;
    }

    private boolean endpointDiscoveryEnabled() {
        Boolean endpointDiscoveryChainSetting = DEFAULT_ENDPOINT_DISCOVERY_PROVIDER.endpointDiscoveryEnabled();
        if (this.endpointDiscoveryDisabled) {
            return false;
        }
        if (this.endpointDiscoveryEnabled) {
            return true;
        }
        if (endpointDiscoveryChainSetting != null && !endpointDiscoveryChainSetting.booleanValue()) {
            return false;
        }
        if (endpointDiscoveryChainSetting != null && endpointDiscoveryChainSetting.booleanValue()) {
            return true;
        }
        return InternalConfig.Factory.getInternalConfig().endpointDiscoveryEnabled();
    }

    @Override
    protected AmazonTimestreamQueryAsync build(AwsAsyncClientParams params) {
        if (this.endpointDiscoveryEnabled() && this.getEndpoint() == null) {
            return new AmazonTimestreamQueryAsyncClient(params, true);
        }
        return new AmazonTimestreamQueryAsyncClient(params);
    }
}

