/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryAsync;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryAsyncClientBuilder;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClient;
import com.amazonaws.services.timestreamquery.model.CancelQueryRequest;
import com.amazonaws.services.timestreamquery.model.CancelQueryResult;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsRequest;
import com.amazonaws.services.timestreamquery.model.DescribeEndpointsResult;
import com.amazonaws.services.timestreamquery.model.QueryRequest;
import com.amazonaws.services.timestreamquery.model.QueryResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTimestreamQueryAsyncClient
extends AmazonTimestreamQueryClient
implements AmazonTimestreamQueryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTimestreamQueryAsyncClientBuilder asyncBuilder() {
        return AmazonTimestreamQueryAsyncClientBuilder.standard();
    }

    AmazonTimestreamQueryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonTimestreamQueryAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelQueryResult> cancelQueryAsync(CancelQueryRequest request) {
        return this.cancelQueryAsync(request, null);
    }

    @Override
    public Future<CancelQueryResult> cancelQueryAsync(CancelQueryRequest request, final AsyncHandler<CancelQueryRequest, CancelQueryResult> asyncHandler) {
        final CancelQueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelQueryResult>(){

            @Override
            public CancelQueryResult call() throws Exception {
                CancelQueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeCancelQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request) {
        return this.describeEndpointsAsync(request, null);
    }

    @Override
    public Future<DescribeEndpointsResult> describeEndpointsAsync(DescribeEndpointsRequest request, final AsyncHandler<DescribeEndpointsRequest, DescribeEndpointsResult> asyncHandler) {
        final DescribeEndpointsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEndpointsResult>(){

            @Override
            public DescribeEndpointsResult call() throws Exception {
                DescribeEndpointsResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeDescribeEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request) {
        return this.queryAsync(request, null);
    }

    @Override
    public Future<QueryResult> queryAsync(QueryRequest request, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) {
        final QueryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult result = null;
                try {
                    result = AmazonTimestreamQueryAsyncClient.this.executeQuery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

