/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.synthetics.model.RuntimeVersion;
import java.util.Date;

@SdkInternalApi
public class RuntimeVersionMarshaller {
    private static final MarshallingInfo<String> VERSIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Date> RELEASEDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DEPRECATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeprecationDate").timestampFormat("unixTimestamp").build();
    private static final RuntimeVersionMarshaller instance = new RuntimeVersionMarshaller();

    public static RuntimeVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(RuntimeVersion runtimeVersion, ProtocolMarshaller protocolMarshaller) {
        if (runtimeVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(runtimeVersion.getVersionName(), VERSIONNAME_BINDING);
            protocolMarshaller.marshall(runtimeVersion.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(runtimeVersion.getReleaseDate(), RELEASEDATE_BINDING);
            protocolMarshaller.marshall(runtimeVersion.getDeprecationDate(), DEPRECATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

