/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.synthetics.model.CanaryCodeInput;
import java.nio.ByteBuffer;

@SdkInternalApi
public class CanaryCodeInputMarshaller {
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Key").build();
    private static final MarshallingInfo<String> S3VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Version").build();
    private static final MarshallingInfo<ByteBuffer> ZIPFILE_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipFile").build();
    private static final MarshallingInfo<String> HANDLER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Handler").build();
    private static final CanaryCodeInputMarshaller instance = new CanaryCodeInputMarshaller();

    public static CanaryCodeInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(CanaryCodeInput canaryCodeInput, ProtocolMarshaller protocolMarshaller) {
        if (canaryCodeInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(canaryCodeInput.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(canaryCodeInput.getS3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall(canaryCodeInput.getS3Version(), S3VERSION_BINDING);
            protocolMarshaller.marshall(canaryCodeInput.getZipFile(), ZIPFILE_BINDING);
            protocolMarshaller.marshall(canaryCodeInput.getHandler(), HANDLER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

