/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.synthetics.AWSSynthetics;
import com.amazonaws.services.synthetics.AWSSyntheticsClientBuilder;
import com.amazonaws.services.synthetics.model.AWSSyntheticsException;
import com.amazonaws.services.synthetics.model.CreateCanaryRequest;
import com.amazonaws.services.synthetics.model.CreateCanaryResult;
import com.amazonaws.services.synthetics.model.DeleteCanaryRequest;
import com.amazonaws.services.synthetics.model.DeleteCanaryResult;
import com.amazonaws.services.synthetics.model.DescribeCanariesLastRunRequest;
import com.amazonaws.services.synthetics.model.DescribeCanariesLastRunResult;
import com.amazonaws.services.synthetics.model.DescribeCanariesRequest;
import com.amazonaws.services.synthetics.model.DescribeCanariesResult;
import com.amazonaws.services.synthetics.model.DescribeRuntimeVersionsRequest;
import com.amazonaws.services.synthetics.model.DescribeRuntimeVersionsResult;
import com.amazonaws.services.synthetics.model.GetCanaryRequest;
import com.amazonaws.services.synthetics.model.GetCanaryResult;
import com.amazonaws.services.synthetics.model.GetCanaryRunsRequest;
import com.amazonaws.services.synthetics.model.GetCanaryRunsResult;
import com.amazonaws.services.synthetics.model.ListTagsForResourceRequest;
import com.amazonaws.services.synthetics.model.ListTagsForResourceResult;
import com.amazonaws.services.synthetics.model.StartCanaryRequest;
import com.amazonaws.services.synthetics.model.StartCanaryResult;
import com.amazonaws.services.synthetics.model.StopCanaryRequest;
import com.amazonaws.services.synthetics.model.StopCanaryResult;
import com.amazonaws.services.synthetics.model.TagResourceRequest;
import com.amazonaws.services.synthetics.model.TagResourceResult;
import com.amazonaws.services.synthetics.model.UntagResourceRequest;
import com.amazonaws.services.synthetics.model.UntagResourceResult;
import com.amazonaws.services.synthetics.model.UpdateCanaryRequest;
import com.amazonaws.services.synthetics.model.UpdateCanaryResult;
import com.amazonaws.services.synthetics.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.CreateCanaryRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.CreateCanaryResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.DeleteCanaryRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.DeleteCanaryResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.DescribeCanariesLastRunRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.DescribeCanariesLastRunResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.DescribeCanariesRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.DescribeCanariesResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.DescribeRuntimeVersionsRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.DescribeRuntimeVersionsResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.GetCanaryRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.GetCanaryResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.GetCanaryRunsRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.GetCanaryRunsResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.StartCanaryRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.StartCanaryResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.StopCanaryRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.StopCanaryResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.UpdateCanaryRequestProtocolMarshaller;
import com.amazonaws.services.synthetics.model.transform.UpdateCanaryResultJsonUnmarshaller;
import com.amazonaws.services.synthetics.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSyntheticsClient
extends AmazonWebServiceClient
implements AWSSynthetics {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSynthetics.class);
    private static final String DEFAULT_SIGNING_NAME = "synthetics";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSyntheticsException.class));

    public static AWSSyntheticsClientBuilder builder() {
        return AWSSyntheticsClientBuilder.standard();
    }

    AWSSyntheticsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSyntheticsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("synthetics.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/synthetics/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/synthetics/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateCanaryResult createCanary(CreateCanaryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateCanary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCanaryResult executeCreateCanary(CreateCanaryRequest createCanaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCanaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCanaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCanaryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createCanaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateCanary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateCanaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCanaryResult createCanaryResult = (CreateCanaryResult)response.getAwsResponse();
            return createCanaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCanaryResult deleteCanary(DeleteCanaryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteCanary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCanaryResult executeDeleteCanary(DeleteCanaryRequest deleteCanaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCanaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCanaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCanaryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteCanaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteCanary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteCanaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCanaryResult deleteCanaryResult = (DeleteCanaryResult)response.getAwsResponse();
            return deleteCanaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCanariesResult describeCanaries(DescribeCanariesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeCanaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCanariesResult executeDescribeCanaries(DescribeCanariesRequest describeCanariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCanariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCanariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCanariesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeCanariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeCanaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeCanariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCanariesResult describeCanariesResult = (DescribeCanariesResult)response.getAwsResponse();
            return describeCanariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeCanariesLastRunResult describeCanariesLastRun(DescribeCanariesLastRunRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeCanariesLastRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeCanariesLastRunResult executeDescribeCanariesLastRun(DescribeCanariesLastRunRequest describeCanariesLastRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeCanariesLastRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeCanariesLastRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeCanariesLastRunRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeCanariesLastRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeCanariesLastRun");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeCanariesLastRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeCanariesLastRunResult describeCanariesLastRunResult = (DescribeCanariesLastRunResult)response.getAwsResponse();
            return describeCanariesLastRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRuntimeVersionsResult describeRuntimeVersions(DescribeRuntimeVersionsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRuntimeVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRuntimeVersionsResult executeDescribeRuntimeVersions(DescribeRuntimeVersionsRequest describeRuntimeVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRuntimeVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRuntimeVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRuntimeVersionsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRuntimeVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeRuntimeVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRuntimeVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRuntimeVersionsResult describeRuntimeVersionsResult = (DescribeRuntimeVersionsResult)response.getAwsResponse();
            return describeRuntimeVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCanaryResult getCanary(GetCanaryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetCanary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCanaryResult executeGetCanary(GetCanaryRequest getCanaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCanaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCanaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCanaryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getCanaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetCanary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCanaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCanaryResult getCanaryResult = (GetCanaryResult)response.getAwsResponse();
            return getCanaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCanaryRunsResult getCanaryRuns(GetCanaryRunsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetCanaryRuns(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCanaryRunsResult executeGetCanaryRuns(GetCanaryRunsRequest getCanaryRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCanaryRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCanaryRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCanaryRunsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getCanaryRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetCanaryRuns");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCanaryRunsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCanaryRunsResult getCanaryRunsResult = (GetCanaryRunsResult)response.getAwsResponse();
            return getCanaryRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartCanaryResult startCanary(StartCanaryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartCanary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartCanaryResult executeStartCanary(StartCanaryRequest startCanaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startCanaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartCanaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartCanaryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startCanaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartCanary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartCanaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartCanaryResult startCanaryResult = (StartCanaryResult)response.getAwsResponse();
            return startCanaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopCanaryResult stopCanary(StopCanaryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStopCanary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopCanaryResult executeStopCanary(StopCanaryRequest stopCanaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopCanaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopCanaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopCanaryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(stopCanaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StopCanary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopCanaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopCanaryResult stopCanaryResult = (StopCanaryResult)response.getAwsResponse();
            return stopCanaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateCanaryResult updateCanary(UpdateCanaryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateCanary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateCanaryResult executeUpdateCanary(UpdateCanaryRequest updateCanaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateCanaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateCanaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateCanaryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateCanaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateCanary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateCanaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateCanaryResult updateCanaryResult = (UpdateCanaryResult)response.getAwsResponse();
            return updateCanaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

