/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.synthetics.AWSSyntheticsAsync;
import com.amazonaws.services.synthetics.AWSSyntheticsAsyncClientBuilder;
import com.amazonaws.services.synthetics.AWSSyntheticsClient;
import com.amazonaws.services.synthetics.model.CreateCanaryRequest;
import com.amazonaws.services.synthetics.model.CreateCanaryResult;
import com.amazonaws.services.synthetics.model.DeleteCanaryRequest;
import com.amazonaws.services.synthetics.model.DeleteCanaryResult;
import com.amazonaws.services.synthetics.model.DescribeCanariesLastRunRequest;
import com.amazonaws.services.synthetics.model.DescribeCanariesLastRunResult;
import com.amazonaws.services.synthetics.model.DescribeCanariesRequest;
import com.amazonaws.services.synthetics.model.DescribeCanariesResult;
import com.amazonaws.services.synthetics.model.DescribeRuntimeVersionsRequest;
import com.amazonaws.services.synthetics.model.DescribeRuntimeVersionsResult;
import com.amazonaws.services.synthetics.model.GetCanaryRequest;
import com.amazonaws.services.synthetics.model.GetCanaryResult;
import com.amazonaws.services.synthetics.model.GetCanaryRunsRequest;
import com.amazonaws.services.synthetics.model.GetCanaryRunsResult;
import com.amazonaws.services.synthetics.model.ListTagsForResourceRequest;
import com.amazonaws.services.synthetics.model.ListTagsForResourceResult;
import com.amazonaws.services.synthetics.model.StartCanaryRequest;
import com.amazonaws.services.synthetics.model.StartCanaryResult;
import com.amazonaws.services.synthetics.model.StopCanaryRequest;
import com.amazonaws.services.synthetics.model.StopCanaryResult;
import com.amazonaws.services.synthetics.model.TagResourceRequest;
import com.amazonaws.services.synthetics.model.TagResourceResult;
import com.amazonaws.services.synthetics.model.UntagResourceRequest;
import com.amazonaws.services.synthetics.model.UntagResourceResult;
import com.amazonaws.services.synthetics.model.UpdateCanaryRequest;
import com.amazonaws.services.synthetics.model.UpdateCanaryResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSyntheticsAsyncClient
extends AWSSyntheticsClient
implements AWSSyntheticsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSyntheticsAsyncClientBuilder asyncBuilder() {
        return AWSSyntheticsAsyncClientBuilder.standard();
    }

    AWSSyntheticsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSyntheticsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCanaryResult> createCanaryAsync(CreateCanaryRequest request) {
        return this.createCanaryAsync(request, null);
    }

    @Override
    public Future<CreateCanaryResult> createCanaryAsync(CreateCanaryRequest request, final AsyncHandler<CreateCanaryRequest, CreateCanaryResult> asyncHandler) {
        final CreateCanaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCanaryResult>(){

            @Override
            public CreateCanaryResult call() throws Exception {
                CreateCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeCreateCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCanaryResult> deleteCanaryAsync(DeleteCanaryRequest request) {
        return this.deleteCanaryAsync(request, null);
    }

    @Override
    public Future<DeleteCanaryResult> deleteCanaryAsync(DeleteCanaryRequest request, final AsyncHandler<DeleteCanaryRequest, DeleteCanaryResult> asyncHandler) {
        final DeleteCanaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCanaryResult>(){

            @Override
            public DeleteCanaryResult call() throws Exception {
                DeleteCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDeleteCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCanariesResult> describeCanariesAsync(DescribeCanariesRequest request) {
        return this.describeCanariesAsync(request, null);
    }

    @Override
    public Future<DescribeCanariesResult> describeCanariesAsync(DescribeCanariesRequest request, final AsyncHandler<DescribeCanariesRequest, DescribeCanariesResult> asyncHandler) {
        final DescribeCanariesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCanariesResult>(){

            @Override
            public DescribeCanariesResult call() throws Exception {
                DescribeCanariesResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDescribeCanaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCanariesLastRunResult> describeCanariesLastRunAsync(DescribeCanariesLastRunRequest request) {
        return this.describeCanariesLastRunAsync(request, null);
    }

    @Override
    public Future<DescribeCanariesLastRunResult> describeCanariesLastRunAsync(DescribeCanariesLastRunRequest request, final AsyncHandler<DescribeCanariesLastRunRequest, DescribeCanariesLastRunResult> asyncHandler) {
        final DescribeCanariesLastRunRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCanariesLastRunResult>(){

            @Override
            public DescribeCanariesLastRunResult call() throws Exception {
                DescribeCanariesLastRunResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDescribeCanariesLastRun(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRuntimeVersionsResult> describeRuntimeVersionsAsync(DescribeRuntimeVersionsRequest request) {
        return this.describeRuntimeVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeRuntimeVersionsResult> describeRuntimeVersionsAsync(DescribeRuntimeVersionsRequest request, final AsyncHandler<DescribeRuntimeVersionsRequest, DescribeRuntimeVersionsResult> asyncHandler) {
        final DescribeRuntimeVersionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRuntimeVersionsResult>(){

            @Override
            public DescribeRuntimeVersionsResult call() throws Exception {
                DescribeRuntimeVersionsResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeDescribeRuntimeVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCanaryResult> getCanaryAsync(GetCanaryRequest request) {
        return this.getCanaryAsync(request, null);
    }

    @Override
    public Future<GetCanaryResult> getCanaryAsync(GetCanaryRequest request, final AsyncHandler<GetCanaryRequest, GetCanaryResult> asyncHandler) {
        final GetCanaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCanaryResult>(){

            @Override
            public GetCanaryResult call() throws Exception {
                GetCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeGetCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCanaryRunsResult> getCanaryRunsAsync(GetCanaryRunsRequest request) {
        return this.getCanaryRunsAsync(request, null);
    }

    @Override
    public Future<GetCanaryRunsResult> getCanaryRunsAsync(GetCanaryRunsRequest request, final AsyncHandler<GetCanaryRunsRequest, GetCanaryRunsResult> asyncHandler) {
        final GetCanaryRunsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCanaryRunsResult>(){

            @Override
            public GetCanaryRunsResult call() throws Exception {
                GetCanaryRunsResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeGetCanaryRuns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartCanaryResult> startCanaryAsync(StartCanaryRequest request) {
        return this.startCanaryAsync(request, null);
    }

    @Override
    public Future<StartCanaryResult> startCanaryAsync(StartCanaryRequest request, final AsyncHandler<StartCanaryRequest, StartCanaryResult> asyncHandler) {
        final StartCanaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartCanaryResult>(){

            @Override
            public StartCanaryResult call() throws Exception {
                StartCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeStartCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopCanaryResult> stopCanaryAsync(StopCanaryRequest request) {
        return this.stopCanaryAsync(request, null);
    }

    @Override
    public Future<StopCanaryResult> stopCanaryAsync(StopCanaryRequest request, final AsyncHandler<StopCanaryRequest, StopCanaryResult> asyncHandler) {
        final StopCanaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopCanaryResult>(){

            @Override
            public StopCanaryResult call() throws Exception {
                StopCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeStopCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCanaryResult> updateCanaryAsync(UpdateCanaryRequest request) {
        return this.updateCanaryAsync(request, null);
    }

    @Override
    public Future<UpdateCanaryResult> updateCanaryAsync(UpdateCanaryRequest request, final AsyncHandler<UpdateCanaryRequest, UpdateCanaryResult> asyncHandler) {
        final UpdateCanaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCanaryResult>(){

            @Override
            public UpdateCanaryResult call() throws Exception {
                UpdateCanaryResult result = null;
                try {
                    result = AWSSyntheticsAsyncClient.this.executeUpdateCanary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

