/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssoadmin;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ssoadmin.AWSSSOAdmin;
import com.amazonaws.services.ssoadmin.AWSSSOAdminClientBuilder;
import com.amazonaws.services.ssoadmin.model.AWSSSOAdminException;
import com.amazonaws.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.CreateAccountAssignmentRequest;
import com.amazonaws.services.ssoadmin.model.CreateAccountAssignmentResult;
import com.amazonaws.services.ssoadmin.model.CreatePermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.CreatePermissionSetResult;
import com.amazonaws.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import com.amazonaws.services.ssoadmin.model.DeleteAccountAssignmentResult;
import com.amazonaws.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.DeletePermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.DeletePermissionSetResult;
import com.amazonaws.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import com.amazonaws.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResult;
import com.amazonaws.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import com.amazonaws.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResult;
import com.amazonaws.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import com.amazonaws.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResult;
import com.amazonaws.services.ssoadmin.model.DescribePermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.DescribePermissionSetResult;
import com.amazonaws.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.GetInlinePolicyForPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import com.amazonaws.services.ssoadmin.model.ListAccountAssignmentCreationStatusResult;
import com.amazonaws.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import com.amazonaws.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResult;
import com.amazonaws.services.ssoadmin.model.ListAccountAssignmentsRequest;
import com.amazonaws.services.ssoadmin.model.ListAccountAssignmentsResult;
import com.amazonaws.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.ListInstancesRequest;
import com.amazonaws.services.ssoadmin.model.ListInstancesResult;
import com.amazonaws.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import com.amazonaws.services.ssoadmin.model.ListPermissionSetProvisioningStatusResult;
import com.amazonaws.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import com.amazonaws.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResult;
import com.amazonaws.services.ssoadmin.model.ListPermissionSetsRequest;
import com.amazonaws.services.ssoadmin.model.ListPermissionSetsResult;
import com.amazonaws.services.ssoadmin.model.ListTagsForResourceRequest;
import com.amazonaws.services.ssoadmin.model.ListTagsForResourceResult;
import com.amazonaws.services.ssoadmin.model.ProvisionPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.ProvisionPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.PutInlinePolicyToPermissionSetResult;
import com.amazonaws.services.ssoadmin.model.TagResourceRequest;
import com.amazonaws.services.ssoadmin.model.TagResourceResult;
import com.amazonaws.services.ssoadmin.model.UntagResourceRequest;
import com.amazonaws.services.ssoadmin.model.UntagResourceResult;
import com.amazonaws.services.ssoadmin.model.UpdatePermissionSetRequest;
import com.amazonaws.services.ssoadmin.model.UpdatePermissionSetResult;
import com.amazonaws.services.ssoadmin.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.AttachManagedPolicyToPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.AttachManagedPolicyToPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.CreateAccountAssignmentRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.CreateAccountAssignmentResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.CreatePermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.CreatePermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DeleteAccountAssignmentRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DeleteAccountAssignmentResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DeleteInlinePolicyFromPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DeleteInlinePolicyFromPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DeletePermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DeletePermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribeAccountAssignmentCreationStatusRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribeAccountAssignmentCreationStatusResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribeAccountAssignmentDeletionStatusRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribeAccountAssignmentDeletionStatusResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribePermissionSetProvisioningStatusRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribePermissionSetProvisioningStatusResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribePermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DescribePermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DetachManagedPolicyFromPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.DetachManagedPolicyFromPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.GetInlinePolicyForPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.GetInlinePolicyForPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountAssignmentCreationStatusRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountAssignmentCreationStatusResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountAssignmentDeletionStatusRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountAssignmentDeletionStatusResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountAssignmentsRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountAssignmentsResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountsForProvisionedPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListAccountsForProvisionedPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListInstancesRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListManagedPoliciesInPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListManagedPoliciesInPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListPermissionSetProvisioningStatusRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListPermissionSetProvisioningStatusResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListPermissionSetsProvisionedToAccountRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListPermissionSetsProvisionedToAccountResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListPermissionSetsRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListPermissionSetsResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ProvisionPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ProvisionPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.PutInlinePolicyToPermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.PutInlinePolicyToPermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.UpdatePermissionSetRequestProtocolMarshaller;
import com.amazonaws.services.ssoadmin.model.transform.UpdatePermissionSetResultJsonUnmarshaller;
import com.amazonaws.services.ssoadmin.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSSOAdminClient
extends AmazonWebServiceClient
implements AWSSSOAdmin {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSSOAdmin.class);
    private static final String DEFAULT_SIGNING_NAME = "sso";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller(ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSSOAdminException.class));

    public static AWSSSOAdminClientBuilder builder() {
        return AWSSSOAdminClientBuilder.standard();
    }

    AWSSSOAdminClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSSOAdminClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("sso.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ssoadmin/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ssoadmin/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AttachManagedPolicyToPermissionSetResult attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAttachManagedPolicyToPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AttachManagedPolicyToPermissionSetResult executeAttachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(attachManagedPolicyToPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AttachManagedPolicyToPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AttachManagedPolicyToPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(attachManagedPolicyToPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AttachManagedPolicyToPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AttachManagedPolicyToPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AttachManagedPolicyToPermissionSetResult attachManagedPolicyToPermissionSetResult = (AttachManagedPolicyToPermissionSetResult)response.getAwsResponse();
            return attachManagedPolicyToPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAccountAssignmentResult createAccountAssignment(CreateAccountAssignmentRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateAccountAssignment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAccountAssignmentResult executeCreateAccountAssignment(CreateAccountAssignmentRequest createAccountAssignmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAccountAssignmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAccountAssignmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAccountAssignmentRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createAccountAssignmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateAccountAssignment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateAccountAssignmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAccountAssignmentResult createAccountAssignmentResult = (CreateAccountAssignmentResult)response.getAwsResponse();
            return createAccountAssignmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePermissionSetResult createPermissionSet(CreatePermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreatePermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePermissionSetResult executeCreatePermissionSet(CreatePermissionSetRequest createPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreatePermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreatePermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePermissionSetResult createPermissionSetResult = (CreatePermissionSetResult)response.getAwsResponse();
            return createPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccountAssignmentResult deleteAccountAssignment(DeleteAccountAssignmentRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteAccountAssignment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccountAssignmentResult executeDeleteAccountAssignment(DeleteAccountAssignmentRequest deleteAccountAssignmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccountAssignmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccountAssignmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccountAssignmentRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteAccountAssignmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteAccountAssignment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteAccountAssignmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAccountAssignmentResult deleteAccountAssignmentResult = (DeleteAccountAssignmentResult)response.getAwsResponse();
            return deleteAccountAssignmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInlinePolicyFromPermissionSetResult deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteInlinePolicyFromPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInlinePolicyFromPermissionSetResult executeDeleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInlinePolicyFromPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInlinePolicyFromPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInlinePolicyFromPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteInlinePolicyFromPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteInlinePolicyFromPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteInlinePolicyFromPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInlinePolicyFromPermissionSetResult deleteInlinePolicyFromPermissionSetResult = (DeleteInlinePolicyFromPermissionSetResult)response.getAwsResponse();
            return deleteInlinePolicyFromPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePermissionSetResult deletePermissionSet(DeletePermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeletePermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePermissionSetResult executeDeletePermissionSet(DeletePermissionSetRequest deletePermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deletePermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeletePermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeletePermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePermissionSetResult deletePermissionSetResult = (DeletePermissionSetResult)response.getAwsResponse();
            return deletePermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountAssignmentCreationStatusResult describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeAccountAssignmentCreationStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAccountAssignmentCreationStatusResult executeDescribeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountAssignmentCreationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountAssignmentCreationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountAssignmentCreationStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeAccountAssignmentCreationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeAccountAssignmentCreationStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeAccountAssignmentCreationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAccountAssignmentCreationStatusResult describeAccountAssignmentCreationStatusResult = (DescribeAccountAssignmentCreationStatusResult)response.getAwsResponse();
            return describeAccountAssignmentCreationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountAssignmentDeletionStatusResult describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeAccountAssignmentDeletionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAccountAssignmentDeletionStatusResult executeDescribeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountAssignmentDeletionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountAssignmentDeletionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountAssignmentDeletionStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeAccountAssignmentDeletionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeAccountAssignmentDeletionStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeAccountAssignmentDeletionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAccountAssignmentDeletionStatusResult describeAccountAssignmentDeletionStatusResult = (DescribeAccountAssignmentDeletionStatusResult)response.getAwsResponse();
            return describeAccountAssignmentDeletionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePermissionSetResult describePermissionSet(DescribePermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribePermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePermissionSetResult executeDescribePermissionSet(DescribePermissionSetRequest describePermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describePermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribePermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribePermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePermissionSetResult describePermissionSetResult = (DescribePermissionSetResult)response.getAwsResponse();
            return describePermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePermissionSetProvisioningStatusResult describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribePermissionSetProvisioningStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePermissionSetProvisioningStatusResult executeDescribePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePermissionSetProvisioningStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePermissionSetProvisioningStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePermissionSetProvisioningStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describePermissionSetProvisioningStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribePermissionSetProvisioningStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribePermissionSetProvisioningStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePermissionSetProvisioningStatusResult describePermissionSetProvisioningStatusResult = (DescribePermissionSetProvisioningStatusResult)response.getAwsResponse();
            return describePermissionSetProvisioningStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DetachManagedPolicyFromPermissionSetResult detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDetachManagedPolicyFromPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DetachManagedPolicyFromPermissionSetResult executeDetachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(detachManagedPolicyFromPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DetachManagedPolicyFromPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DetachManagedPolicyFromPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(detachManagedPolicyFromPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DetachManagedPolicyFromPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DetachManagedPolicyFromPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DetachManagedPolicyFromPermissionSetResult detachManagedPolicyFromPermissionSetResult = (DetachManagedPolicyFromPermissionSetResult)response.getAwsResponse();
            return detachManagedPolicyFromPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetInlinePolicyForPermissionSetResult getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetInlinePolicyForPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetInlinePolicyForPermissionSetResult executeGetInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getInlinePolicyForPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetInlinePolicyForPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetInlinePolicyForPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getInlinePolicyForPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetInlinePolicyForPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetInlinePolicyForPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetInlinePolicyForPermissionSetResult getInlinePolicyForPermissionSetResult = (GetInlinePolicyForPermissionSetResult)response.getAwsResponse();
            return getInlinePolicyForPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccountAssignmentCreationStatusResult listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListAccountAssignmentCreationStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccountAssignmentCreationStatusResult executeListAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccountAssignmentCreationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccountAssignmentCreationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccountAssignmentCreationStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listAccountAssignmentCreationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListAccountAssignmentCreationStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListAccountAssignmentCreationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAccountAssignmentCreationStatusResult listAccountAssignmentCreationStatusResult = (ListAccountAssignmentCreationStatusResult)response.getAwsResponse();
            return listAccountAssignmentCreationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccountAssignmentDeletionStatusResult listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListAccountAssignmentDeletionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccountAssignmentDeletionStatusResult executeListAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccountAssignmentDeletionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccountAssignmentDeletionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccountAssignmentDeletionStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listAccountAssignmentDeletionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListAccountAssignmentDeletionStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListAccountAssignmentDeletionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAccountAssignmentDeletionStatusResult listAccountAssignmentDeletionStatusResult = (ListAccountAssignmentDeletionStatusResult)response.getAwsResponse();
            return listAccountAssignmentDeletionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccountAssignmentsResult listAccountAssignments(ListAccountAssignmentsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListAccountAssignments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccountAssignmentsResult executeListAccountAssignments(ListAccountAssignmentsRequest listAccountAssignmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccountAssignmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccountAssignmentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccountAssignmentsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listAccountAssignmentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListAccountAssignments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListAccountAssignmentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAccountAssignmentsResult listAccountAssignmentsResult = (ListAccountAssignmentsResult)response.getAwsResponse();
            return listAccountAssignmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccountsForProvisionedPermissionSetResult listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListAccountsForProvisionedPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccountsForProvisionedPermissionSetResult executeListAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccountsForProvisionedPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccountsForProvisionedPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccountsForProvisionedPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listAccountsForProvisionedPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListAccountsForProvisionedPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListAccountsForProvisionedPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAccountsForProvisionedPermissionSetResult listAccountsForProvisionedPermissionSetResult = (ListAccountsForProvisionedPermissionSetResult)response.getAwsResponse();
            return listAccountsForProvisionedPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInstancesResult listInstances(ListInstancesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInstancesResult executeListInstances(ListInstancesRequest listInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstancesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInstancesResult listInstancesResult = (ListInstancesResult)response.getAwsResponse();
            return listInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListManagedPoliciesInPermissionSetResult listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListManagedPoliciesInPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListManagedPoliciesInPermissionSetResult executeListManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listManagedPoliciesInPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListManagedPoliciesInPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListManagedPoliciesInPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listManagedPoliciesInPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListManagedPoliciesInPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListManagedPoliciesInPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListManagedPoliciesInPermissionSetResult listManagedPoliciesInPermissionSetResult = (ListManagedPoliciesInPermissionSetResult)response.getAwsResponse();
            return listManagedPoliciesInPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPermissionSetProvisioningStatusResult listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListPermissionSetProvisioningStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPermissionSetProvisioningStatusResult executeListPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPermissionSetProvisioningStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPermissionSetProvisioningStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPermissionSetProvisioningStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listPermissionSetProvisioningStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListPermissionSetProvisioningStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListPermissionSetProvisioningStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPermissionSetProvisioningStatusResult listPermissionSetProvisioningStatusResult = (ListPermissionSetProvisioningStatusResult)response.getAwsResponse();
            return listPermissionSetProvisioningStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPermissionSetsResult listPermissionSets(ListPermissionSetsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListPermissionSets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPermissionSetsResult executeListPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPermissionSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPermissionSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPermissionSetsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listPermissionSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListPermissionSets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListPermissionSetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPermissionSetsResult listPermissionSetsResult = (ListPermissionSetsResult)response.getAwsResponse();
            return listPermissionSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPermissionSetsProvisionedToAccountResult listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListPermissionSetsProvisionedToAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPermissionSetsProvisionedToAccountResult executeListPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPermissionSetsProvisionedToAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPermissionSetsProvisionedToAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPermissionSetsProvisionedToAccountRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listPermissionSetsProvisionedToAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListPermissionSetsProvisionedToAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListPermissionSetsProvisionedToAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPermissionSetsProvisionedToAccountResult listPermissionSetsProvisionedToAccountResult = (ListPermissionSetsProvisionedToAccountResult)response.getAwsResponse();
            return listPermissionSetsProvisionedToAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ProvisionPermissionSetResult provisionPermissionSet(ProvisionPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeProvisionPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ProvisionPermissionSetResult executeProvisionPermissionSet(ProvisionPermissionSetRequest provisionPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(provisionPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ProvisionPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ProvisionPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(provisionPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ProvisionPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ProvisionPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ProvisionPermissionSetResult provisionPermissionSetResult = (ProvisionPermissionSetResult)response.getAwsResponse();
            return provisionPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutInlinePolicyToPermissionSetResult putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutInlinePolicyToPermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutInlinePolicyToPermissionSetResult executePutInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putInlinePolicyToPermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutInlinePolicyToPermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutInlinePolicyToPermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putInlinePolicyToPermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutInlinePolicyToPermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutInlinePolicyToPermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutInlinePolicyToPermissionSetResult putInlinePolicyToPermissionSetResult = (PutInlinePolicyToPermissionSetResult)response.getAwsResponse();
            return putInlinePolicyToPermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePermissionSetResult updatePermissionSet(UpdatePermissionSetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdatePermissionSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePermissionSetResult executeUpdatePermissionSet(UpdatePermissionSetRequest updatePermissionSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePermissionSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePermissionSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePermissionSetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updatePermissionSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "SSO Admin");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdatePermissionSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdatePermissionSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePermissionSetResult updatePermissionSetResult = (UpdatePermissionSetResult)response.getAwsResponse();
            return updatePermissionSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

