/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.BulkEmailEntry;
import java.util.List;

@SdkInternalApi
public class BulkEmailEntryMarshaller {
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destination").build();
    private static final MarshallingInfo<List> REPLACEMENTTAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplacementTags").build();
    private static final MarshallingInfo<StructuredPojo> REPLACEMENTEMAILCONTENT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplacementEmailContent").build();
    private static final BulkEmailEntryMarshaller instance = new BulkEmailEntryMarshaller();

    public static BulkEmailEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(BulkEmailEntry bulkEmailEntry, ProtocolMarshaller protocolMarshaller) {
        if (bulkEmailEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(bulkEmailEntry.getDestination(), DESTINATION_BINDING);
            protocolMarshaller.marshall(bulkEmailEntry.getReplacementTags(), REPLACEMENTTAGS_BINDING);
            protocolMarshaller.marshall(bulkEmailEntry.getReplacementEmailContent(), REPLACEMENTEMAILCONTENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

