/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemas.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.schemas.model.DescribeCodeBindingResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class CodeBindingExists {
    CodeBindingExists() {
    }

    static class IsNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeCodeBindingResult> {
        IsNotFoundExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "NotFoundException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsCREATE_FAILEDMatcher
    extends WaiterAcceptor<DescribeCodeBindingResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCREATE_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeCodeBindingResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("Status");
        }
    }

    static class IsCREATE_IN_PROGRESSMatcher
    extends WaiterAcceptor<DescribeCodeBindingResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCREATE_IN_PROGRESSMatcher() {
        }

        @Override
        public boolean matches(DescribeCodeBindingResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_IN_PROGRESS\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("Status");
        }
    }

    static class IsCREATE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeCodeBindingResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCREATE_COMPLETEMatcher() {
        }

        @Override
        public boolean matches(DescribeCodeBindingResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("Status");
        }
    }
}

