/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftdataapi.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftdataapi.model.Field;
import java.nio.ByteBuffer;

@SdkInternalApi
public class FieldMarshaller {
    private static final MarshallingInfo<ByteBuffer> BLOBVALUE_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blobValue").build();
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("booleanValue").build();
    private static final MarshallingInfo<Double> DOUBLEVALUE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("doubleValue").build();
    private static final MarshallingInfo<Boolean> ISNULL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isNull").build();
    private static final MarshallingInfo<Long> LONGVALUE_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("longValue").build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").build();
    private static final FieldMarshaller instance = new FieldMarshaller();

    public static FieldMarshaller getInstance() {
        return instance;
    }

    public void marshall(Field field, ProtocolMarshaller protocolMarshaller) {
        if (field == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(field.getBlobValue(), BLOBVALUE_BINDING);
            protocolMarshaller.marshall(field.getBooleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall(field.getDoubleValue(), DOUBLEVALUE_BINDING);
            protocolMarshaller.marshall(field.getIsNull(), ISNULL_BINDING);
            protocolMarshaller.marshall(field.getLongValue(), LONGVALUE_BINDING);
            protocolMarshaller.marshall(field.getStringValue(), STRINGVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

