/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.UserIdentity;

@SdkInternalApi
public class UserIdentityMarshaller {
    private static final MarshallingInfo<StructuredPojo> ASSUMEDROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assumedRole").build();
    private static final MarshallingInfo<StructuredPojo> AWSACCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsAccount").build();
    private static final MarshallingInfo<StructuredPojo> AWSSERVICE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsService").build();
    private static final MarshallingInfo<StructuredPojo> FEDERATEDUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("federatedUser").build();
    private static final MarshallingInfo<StructuredPojo> IAMUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamUser").build();
    private static final MarshallingInfo<StructuredPojo> ROOT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("root").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final UserIdentityMarshaller instance = new UserIdentityMarshaller();

    public static UserIdentityMarshaller getInstance() {
        return instance;
    }

    public void marshall(UserIdentity userIdentity, ProtocolMarshaller protocolMarshaller) {
        if (userIdentity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(userIdentity.getAssumedRole(), ASSUMEDROLE_BINDING);
            protocolMarshaller.marshall(userIdentity.getAwsAccount(), AWSACCOUNT_BINDING);
            protocolMarshaller.marshall(userIdentity.getAwsService(), AWSSERVICE_BINDING);
            protocolMarshaller.marshall(userIdentity.getFederatedUser(), FEDERATEDUSER_BINDING);
            protocolMarshaller.marshall(userIdentity.getIamUser(), IAMUSER_BINDING);
            protocolMarshaller.marshall(userIdentity.getRoot(), ROOT_BINDING);
            protocolMarshaller.marshall(userIdentity.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

