/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.SessionContext;

@SdkInternalApi
public class SessionContextMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<StructuredPojo> SESSIONISSUER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionIssuer").build();
    private static final SessionContextMarshaller instance = new SessionContextMarshaller();

    public static SessionContextMarshaller getInstance() {
        return instance;
    }

    public void marshall(SessionContext sessionContext, ProtocolMarshaller protocolMarshaller) {
        if (sessionContext == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sessionContext.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(sessionContext.getSessionIssuer(), SESSIONISSUER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

