/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.SensitiveDataItem;
import java.util.List;

@SdkInternalApi
public class SensitiveDataItemMarshaller {
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").build();
    private static final MarshallingInfo<List> DETECTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detections").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalCount").build();
    private static final SensitiveDataItemMarshaller instance = new SensitiveDataItemMarshaller();

    public static SensitiveDataItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(SensitiveDataItem sensitiveDataItem, ProtocolMarshaller protocolMarshaller) {
        if (sensitiveDataItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sensitiveDataItem.getCategory(), CATEGORY_BINDING);
            protocolMarshaller.marshall(sensitiveDataItem.getDetections(), DETECTIONS_BINDING);
            protocolMarshaller.marshall(sensitiveDataItem.getTotalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

