/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.services.macie2.model.KeyValuePair;
import com.amazonaws.services.macie2.model.S3Object;
import com.amazonaws.services.macie2.model.transform.KeyValuePairJsonUnmarshaller;
import com.amazonaws.services.macie2.model.transform.ServerSideEncryptionJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ObjectJsonUnmarshaller
implements Unmarshaller<S3Object, JsonUnmarshallerContext> {
    private static S3ObjectJsonUnmarshaller instance;

    @Override
    public S3Object unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Object s3Object = new S3Object();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucketArn", targetDepth)) {
                    context.nextToken();
                    s3Object.setBucketArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("eTag", targetDepth)) {
                    context.nextToken();
                    s3Object.setETag(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("extension", targetDepth)) {
                    context.nextToken();
                    s3Object.setExtension(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    s3Object.setKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastModified", targetDepth)) {
                    context.nextToken();
                    s3Object.setLastModified(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
                if (context.testExpression("path", targetDepth)) {
                    context.nextToken();
                    s3Object.setPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("publicAccess", targetDepth)) {
                    context.nextToken();
                    s3Object.setPublicAccess(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("serverSideEncryption", targetDepth)) {
                    context.nextToken();
                    s3Object.setServerSideEncryption(ServerSideEncryptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("size", targetDepth)) {
                    context.nextToken();
                    s3Object.setSize(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("storageClass", targetDepth)) {
                    context.nextToken();
                    s3Object.setStorageClass(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    s3Object.setTags(new ListUnmarshaller<KeyValuePair>(KeyValuePairJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("versionId", targetDepth)) {
                    context.nextToken();
                    s3Object.setVersionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Object;
    }

    public static S3ObjectJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectJsonUnmarshaller();
        }
        return instance;
    }
}

