/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.S3Destination;

@SdkInternalApi
public class S3DestinationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> KEYPREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPrefix").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyArn").build();
    private static final S3DestinationMarshaller instance = new S3DestinationMarshaller();

    public static S3DestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Destination s3Destination, ProtocolMarshaller protocolMarshaller) {
        if (s3Destination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3Destination.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(s3Destination.getKeyPrefix(), KEYPREFIX_BINDING);
            protocolMarshaller.marshall(s3Destination.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

