/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.services.macie2.model.KeyValuePair;
import com.amazonaws.services.macie2.model.S3Bucket;
import com.amazonaws.services.macie2.model.transform.BucketPublicAccessJsonUnmarshaller;
import com.amazonaws.services.macie2.model.transform.KeyValuePairJsonUnmarshaller;
import com.amazonaws.services.macie2.model.transform.S3BucketOwnerJsonUnmarshaller;
import com.amazonaws.services.macie2.model.transform.ServerSideEncryptionJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3BucketJsonUnmarshaller
implements Unmarshaller<S3Bucket, JsonUnmarshallerContext> {
    private static S3BucketJsonUnmarshaller instance;

    @Override
    public S3Bucket unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Bucket s3Bucket = new S3Bucket();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setCreatedAt(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
                if (context.testExpression("defaultServerSideEncryption", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setDefaultServerSideEncryption(ServerSideEncryptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("owner", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setOwner(S3BucketOwnerJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("publicAccess", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setPublicAccess(BucketPublicAccessJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setTags(new ListUnmarshaller<KeyValuePair>(KeyValuePairJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Bucket;
    }

    public static S3BucketJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3BucketJsonUnmarshaller();
        }
        return instance;
    }
}

