/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.ReplicationDetails;
import java.util.List;

@SdkInternalApi
public class ReplicationDetailsMarshaller {
    private static final MarshallingInfo<Boolean> REPLICATED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicated").build();
    private static final MarshallingInfo<Boolean> REPLICATEDEXTERNALLY_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicatedExternally").build();
    private static final MarshallingInfo<List> REPLICATIONACCOUNTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationAccounts").build();
    private static final ReplicationDetailsMarshaller instance = new ReplicationDetailsMarshaller();

    public static ReplicationDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReplicationDetails replicationDetails, ProtocolMarshaller protocolMarshaller) {
        if (replicationDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(replicationDetails.getReplicated(), REPLICATED_BINDING);
            protocolMarshaller.marshall(replicationDetails.getReplicatedExternally(), REPLICATEDEXTERNALLY_BINDING);
            protocolMarshaller.marshall(replicationDetails.getReplicationAccounts(), REPLICATIONACCOUNTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

