/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.IpGeoLocation;

@SdkInternalApi
public class IpGeoLocationMarshaller {
    private static final MarshallingInfo<Double> LAT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lat").build();
    private static final MarshallingInfo<Double> LON_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lon").build();
    private static final IpGeoLocationMarshaller instance = new IpGeoLocationMarshaller();

    public static IpGeoLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(IpGeoLocation ipGeoLocation, ProtocolMarshaller protocolMarshaller) {
        if (ipGeoLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(ipGeoLocation.getLat(), LAT_BINDING);
            protocolMarshaller.marshall(ipGeoLocation.getLon(), LON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

