/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.GroupCount;

@SdkInternalApi
public class GroupCountMarshaller {
    private static final MarshallingInfo<Long> COUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<String> GROUPKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("groupKey").build();
    private static final GroupCountMarshaller instance = new GroupCountMarshaller();

    public static GroupCountMarshaller getInstance() {
        return instance;
    }

    public void marshall(GroupCount groupCount, ProtocolMarshaller protocolMarshaller) {
        if (groupCount == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(groupCount.getCount(), COUNT_BINDING);
            protocolMarshaller.marshall(groupCount.getGroupKey(), GROUPKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

