/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.FederatedUser;

@SdkInternalApi
public class FederatedUserMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessKeyId").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> PRINCIPALID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principalId").build();
    private static final MarshallingInfo<StructuredPojo> SESSIONCONTEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionContext").build();
    private static final FederatedUserMarshaller instance = new FederatedUserMarshaller();

    public static FederatedUserMarshaller getInstance() {
        return instance;
    }

    public void marshall(FederatedUser federatedUser, ProtocolMarshaller protocolMarshaller) {
        if (federatedUser == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(federatedUser.getAccessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall(federatedUser.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(federatedUser.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(federatedUser.getPrincipalId(), PRINCIPALID_BINDING);
            protocolMarshaller.marshall(federatedUser.getSessionContext(), SESSIONCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

