/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.BucketMetadata;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class BucketMetadataMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketArn").build();
    private static final MarshallingInfo<Date> BUCKETCREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketCreatedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<Long> CLASSIFIABLEOBJECTCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("classifiableObjectCount").build();
    private static final MarshallingInfo<Long> CLASSIFIABLESIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("classifiableSizeInBytes").build();
    private static final MarshallingInfo<Date> LASTUPDATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdated").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Long> OBJECTCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectCount").build();
    private static final MarshallingInfo<StructuredPojo> OBJECTCOUNTBYENCRYPTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectCountByEncryptionType").build();
    private static final MarshallingInfo<StructuredPojo> PUBLICACCESS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicAccess").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").build();
    private static final MarshallingInfo<StructuredPojo> REPLICATIONDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationDetails").build();
    private static final MarshallingInfo<String> SHAREDACCESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sharedAccess").build();
    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInBytes").build();
    private static final MarshallingInfo<Long> SIZEINBYTESCOMPRESSED_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInBytesCompressed").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<StructuredPojo> UNCLASSIFIABLEOBJECTCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unclassifiableObjectCount").build();
    private static final MarshallingInfo<StructuredPojo> UNCLASSIFIABLEOBJECTSIZEINBYTES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unclassifiableObjectSizeInBytes").build();
    private static final MarshallingInfo<Boolean> VERSIONING_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versioning").build();
    private static final BucketMetadataMarshaller instance = new BucketMetadataMarshaller();

    public static BucketMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(BucketMetadata bucketMetadata, ProtocolMarshaller protocolMarshaller) {
        if (bucketMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(bucketMetadata.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getBucketArn(), BUCKETARN_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getBucketCreatedAt(), BUCKETCREATEDAT_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getClassifiableObjectCount(), CLASSIFIABLEOBJECTCOUNT_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getClassifiableSizeInBytes(), CLASSIFIABLESIZEINBYTES_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getLastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getObjectCount(), OBJECTCOUNT_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getObjectCountByEncryptionType(), OBJECTCOUNTBYENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getPublicAccess(), PUBLICACCESS_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getReplicationDetails(), REPLICATIONDETAILS_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getSharedAccess(), SHAREDACCESS_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getSizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getSizeInBytesCompressed(), SIZEINBYTESCOMPRESSED_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getUnclassifiableObjectCount(), UNCLASSIFIABLEOBJECTCOUNT_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getUnclassifiableObjectSizeInBytes(), UNCLASSIFIABLEOBJECTSIZEINBYTES_BINDING);
            protocolMarshaller.marshall(bucketMetadata.getVersioning(), VERSIONING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

