/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.ApiCallDetails;
import java.util.Date;

@SdkInternalApi
public class ApiCallDetailsMarshaller {
    private static final MarshallingInfo<String> API_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("api").build();
    private static final MarshallingInfo<String> APISERVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiServiceName").build();
    private static final MarshallingInfo<Date> FIRSTSEEN_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstSeen").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> LASTSEEN_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastSeen").timestampFormat("iso8601").build();
    private static final ApiCallDetailsMarshaller instance = new ApiCallDetailsMarshaller();

    public static ApiCallDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ApiCallDetails apiCallDetails, ProtocolMarshaller protocolMarshaller) {
        if (apiCallDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(apiCallDetails.getApi(), API_BINDING);
            protocolMarshaller.marshall(apiCallDetails.getApiServiceName(), APISERVICENAME_BINDING);
            protocolMarshaller.marshall(apiCallDetails.getFirstSeen(), FIRSTSEEN_BINDING);
            protocolMarshaller.marshall(apiCallDetails.getLastSeen(), LASTSEEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

