/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.UsageByAccount;
import com.amazonaws.services.macie2.model.transform.UsageRecordMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UsageRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private Date freeTrialStartDate;
    private List<UsageByAccount> usage;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public UsageRecord withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setFreeTrialStartDate(Date freeTrialStartDate) {
        this.freeTrialStartDate = freeTrialStartDate;
    }

    public Date getFreeTrialStartDate() {
        return this.freeTrialStartDate;
    }

    public UsageRecord withFreeTrialStartDate(Date freeTrialStartDate) {
        this.setFreeTrialStartDate(freeTrialStartDate);
        return this;
    }

    public List<UsageByAccount> getUsage() {
        return this.usage;
    }

    public void setUsage(Collection<UsageByAccount> usage) {
        if (usage == null) {
            this.usage = null;
            return;
        }
        this.usage = new ArrayList<UsageByAccount>(usage);
    }

    public UsageRecord withUsage(UsageByAccount ... usage) {
        if (this.usage == null) {
            this.setUsage(new ArrayList<UsageByAccount>(usage.length));
        }
        for (UsageByAccount ele : usage) {
            this.usage.add(ele);
        }
        return this;
    }

    public UsageRecord withUsage(Collection<UsageByAccount> usage) {
        this.setUsage(usage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getFreeTrialStartDate() != null) {
            sb.append("FreeTrialStartDate: ").append(this.getFreeTrialStartDate()).append(",");
        }
        if (this.getUsage() != null) {
            sb.append("Usage: ").append(this.getUsage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getFreeTrialStartDate() == null ^ this.getFreeTrialStartDate() == null) {
            return false;
        }
        if (other.getFreeTrialStartDate() != null && !other.getFreeTrialStartDate().equals(this.getFreeTrialStartDate())) {
            return false;
        }
        if (other.getUsage() == null ^ this.getUsage() == null) {
            return false;
        }
        return other.getUsage() == null || other.getUsage().equals(this.getUsage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getFreeTrialStartDate() == null ? 0 : this.getFreeTrialStartDate().hashCode());
        hashCode = 31 * hashCode + (this.getUsage() == null ? 0 : this.getUsage().hashCode());
        return hashCode;
    }

    public UsageRecord clone() {
        try {
            return (UsageRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UsageRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

