/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.JobComparator;
import com.amazonaws.services.macie2.model.TagTarget;
import com.amazonaws.services.macie2.model.TagValuePair;
import com.amazonaws.services.macie2.model.transform.TagScopeTermMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagScopeTerm
implements Serializable,
Cloneable,
StructuredPojo {
    private String comparator;
    private String key;
    private List<TagValuePair> tagValues;
    private String target;

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public String getComparator() {
        return this.comparator;
    }

    public TagScopeTerm withComparator(String comparator) {
        this.setComparator(comparator);
        return this;
    }

    public TagScopeTerm withComparator(JobComparator comparator) {
        this.comparator = comparator.toString();
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public TagScopeTerm withKey(String key) {
        this.setKey(key);
        return this;
    }

    public List<TagValuePair> getTagValues() {
        return this.tagValues;
    }

    public void setTagValues(Collection<TagValuePair> tagValues) {
        if (tagValues == null) {
            this.tagValues = null;
            return;
        }
        this.tagValues = new ArrayList<TagValuePair>(tagValues);
    }

    public TagScopeTerm withTagValues(TagValuePair ... tagValues) {
        if (this.tagValues == null) {
            this.setTagValues(new ArrayList<TagValuePair>(tagValues.length));
        }
        for (TagValuePair ele : tagValues) {
            this.tagValues.add(ele);
        }
        return this;
    }

    public TagScopeTerm withTagValues(Collection<TagValuePair> tagValues) {
        this.setTagValues(tagValues);
        return this;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public TagScopeTerm withTarget(String target) {
        this.setTarget(target);
        return this;
    }

    public TagScopeTerm withTarget(TagTarget target) {
        this.target = target.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComparator() != null) {
            sb.append("Comparator: ").append(this.getComparator()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getTagValues() != null) {
            sb.append("TagValues: ").append(this.getTagValues()).append(",");
        }
        if (this.getTarget() != null) {
            sb.append("Target: ").append(this.getTarget());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagScopeTerm)) {
            return false;
        }
        TagScopeTerm other = (TagScopeTerm)obj;
        if (other.getComparator() == null ^ this.getComparator() == null) {
            return false;
        }
        if (other.getComparator() != null && !other.getComparator().equals(this.getComparator())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getTagValues() == null ^ this.getTagValues() == null) {
            return false;
        }
        if (other.getTagValues() != null && !other.getTagValues().equals(this.getTagValues())) {
            return false;
        }
        if (other.getTarget() == null ^ this.getTarget() == null) {
            return false;
        }
        return other.getTarget() == null || other.getTarget().equals(this.getTarget());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComparator() == null ? 0 : this.getComparator().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getTagValues() == null ? 0 : this.getTagValues().hashCode());
        hashCode = 31 * hashCode + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        return hashCode;
    }

    public TagScopeTerm clone() {
        try {
            return (TagScopeTerm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagScopeTermMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

