/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.JobStatus;
import com.amazonaws.services.macie2.model.JobType;
import com.amazonaws.services.macie2.model.S3BucketDefinitionForJob;
import com.amazonaws.services.macie2.model.UserPausedDetails;
import com.amazonaws.services.macie2.model.transform.JobSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class JobSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<S3BucketDefinitionForJob> bucketDefinitions;
    private Date createdAt;
    private String jobId;
    private String jobStatus;
    private String jobType;
    private String name;
    private UserPausedDetails userPausedDetails;

    public List<S3BucketDefinitionForJob> getBucketDefinitions() {
        return this.bucketDefinitions;
    }

    public void setBucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
        if (bucketDefinitions == null) {
            this.bucketDefinitions = null;
            return;
        }
        this.bucketDefinitions = new ArrayList<S3BucketDefinitionForJob>(bucketDefinitions);
    }

    public JobSummary withBucketDefinitions(S3BucketDefinitionForJob ... bucketDefinitions) {
        if (this.bucketDefinitions == null) {
            this.setBucketDefinitions(new ArrayList<S3BucketDefinitionForJob>(bucketDefinitions.length));
        }
        for (S3BucketDefinitionForJob ele : bucketDefinitions) {
            this.bucketDefinitions.add(ele);
        }
        return this;
    }

    public JobSummary withBucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
        this.setBucketDefinitions(bucketDefinitions);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public JobSummary withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobSummary withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public JobSummary withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public JobSummary withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public String getJobType() {
        return this.jobType;
    }

    public JobSummary withJobType(String jobType) {
        this.setJobType(jobType);
        return this;
    }

    public JobSummary withJobType(JobType jobType) {
        this.jobType = jobType.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public JobSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setUserPausedDetails(UserPausedDetails userPausedDetails) {
        this.userPausedDetails = userPausedDetails;
    }

    public UserPausedDetails getUserPausedDetails() {
        return this.userPausedDetails;
    }

    public JobSummary withUserPausedDetails(UserPausedDetails userPausedDetails) {
        this.setUserPausedDetails(userPausedDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketDefinitions() != null) {
            sb.append("BucketDefinitions: ").append(this.getBucketDefinitions()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getJobType() != null) {
            sb.append("JobType: ").append(this.getJobType()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getUserPausedDetails() != null) {
            sb.append("UserPausedDetails: ").append(this.getUserPausedDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary)obj;
        if (other.getBucketDefinitions() == null ^ this.getBucketDefinitions() == null) {
            return false;
        }
        if (other.getBucketDefinitions() != null && !other.getBucketDefinitions().equals(this.getBucketDefinitions())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getJobType() == null ^ this.getJobType() == null) {
            return false;
        }
        if (other.getJobType() != null && !other.getJobType().equals(this.getJobType())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getUserPausedDetails() == null ^ this.getUserPausedDetails() == null) {
            return false;
        }
        return other.getUserPausedDetails() == null || other.getUserPausedDetails().equals(this.getUserPausedDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketDefinitions() == null ? 0 : this.getBucketDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getJobType() == null ? 0 : this.getJobType().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getUserPausedDetails() == null ? 0 : this.getUserPausedDetails().hashCode());
        return hashCode;
    }

    public JobSummary clone() {
        try {
            return (JobSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

