/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.ClassificationResultStatus;
import com.amazonaws.services.macie2.model.CustomDataIdentifiers;
import com.amazonaws.services.macie2.model.SensitiveDataItem;
import com.amazonaws.services.macie2.model.transform.ClassificationResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassificationResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean additionalOccurrences;
    private CustomDataIdentifiers customDataIdentifiers;
    private String mimeType;
    private List<SensitiveDataItem> sensitiveData;
    private Long sizeClassified;
    private ClassificationResultStatus status;

    public void setAdditionalOccurrences(Boolean additionalOccurrences) {
        this.additionalOccurrences = additionalOccurrences;
    }

    public Boolean getAdditionalOccurrences() {
        return this.additionalOccurrences;
    }

    public ClassificationResult withAdditionalOccurrences(Boolean additionalOccurrences) {
        this.setAdditionalOccurrences(additionalOccurrences);
        return this;
    }

    public Boolean isAdditionalOccurrences() {
        return this.additionalOccurrences;
    }

    public void setCustomDataIdentifiers(CustomDataIdentifiers customDataIdentifiers) {
        this.customDataIdentifiers = customDataIdentifiers;
    }

    public CustomDataIdentifiers getCustomDataIdentifiers() {
        return this.customDataIdentifiers;
    }

    public ClassificationResult withCustomDataIdentifiers(CustomDataIdentifiers customDataIdentifiers) {
        this.setCustomDataIdentifiers(customDataIdentifiers);
        return this;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public ClassificationResult withMimeType(String mimeType) {
        this.setMimeType(mimeType);
        return this;
    }

    public List<SensitiveDataItem> getSensitiveData() {
        return this.sensitiveData;
    }

    public void setSensitiveData(Collection<SensitiveDataItem> sensitiveData) {
        if (sensitiveData == null) {
            this.sensitiveData = null;
            return;
        }
        this.sensitiveData = new ArrayList<SensitiveDataItem>(sensitiveData);
    }

    public ClassificationResult withSensitiveData(SensitiveDataItem ... sensitiveData) {
        if (this.sensitiveData == null) {
            this.setSensitiveData(new ArrayList<SensitiveDataItem>(sensitiveData.length));
        }
        for (SensitiveDataItem ele : sensitiveData) {
            this.sensitiveData.add(ele);
        }
        return this;
    }

    public ClassificationResult withSensitiveData(Collection<SensitiveDataItem> sensitiveData) {
        this.setSensitiveData(sensitiveData);
        return this;
    }

    public void setSizeClassified(Long sizeClassified) {
        this.sizeClassified = sizeClassified;
    }

    public Long getSizeClassified() {
        return this.sizeClassified;
    }

    public ClassificationResult withSizeClassified(Long sizeClassified) {
        this.setSizeClassified(sizeClassified);
        return this;
    }

    public void setStatus(ClassificationResultStatus status) {
        this.status = status;
    }

    public ClassificationResultStatus getStatus() {
        return this.status;
    }

    public ClassificationResult withStatus(ClassificationResultStatus status) {
        this.setStatus(status);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalOccurrences() != null) {
            sb.append("AdditionalOccurrences: ").append(this.getAdditionalOccurrences()).append(",");
        }
        if (this.getCustomDataIdentifiers() != null) {
            sb.append("CustomDataIdentifiers: ").append(this.getCustomDataIdentifiers()).append(",");
        }
        if (this.getMimeType() != null) {
            sb.append("MimeType: ").append(this.getMimeType()).append(",");
        }
        if (this.getSensitiveData() != null) {
            sb.append("SensitiveData: ").append(this.getSensitiveData()).append(",");
        }
        if (this.getSizeClassified() != null) {
            sb.append("SizeClassified: ").append(this.getSizeClassified()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResult)) {
            return false;
        }
        ClassificationResult other = (ClassificationResult)obj;
        if (other.getAdditionalOccurrences() == null ^ this.getAdditionalOccurrences() == null) {
            return false;
        }
        if (other.getAdditionalOccurrences() != null && !other.getAdditionalOccurrences().equals(this.getAdditionalOccurrences())) {
            return false;
        }
        if (other.getCustomDataIdentifiers() == null ^ this.getCustomDataIdentifiers() == null) {
            return false;
        }
        if (other.getCustomDataIdentifiers() != null && !other.getCustomDataIdentifiers().equals(this.getCustomDataIdentifiers())) {
            return false;
        }
        if (other.getMimeType() == null ^ this.getMimeType() == null) {
            return false;
        }
        if (other.getMimeType() != null && !other.getMimeType().equals(this.getMimeType())) {
            return false;
        }
        if (other.getSensitiveData() == null ^ this.getSensitiveData() == null) {
            return false;
        }
        if (other.getSensitiveData() != null && !other.getSensitiveData().equals(this.getSensitiveData())) {
            return false;
        }
        if (other.getSizeClassified() == null ^ this.getSizeClassified() == null) {
            return false;
        }
        if (other.getSizeClassified() != null && !other.getSizeClassified().equals(this.getSizeClassified())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdditionalOccurrences() == null ? 0 : this.getAdditionalOccurrences().hashCode());
        hashCode = 31 * hashCode + (this.getCustomDataIdentifiers() == null ? 0 : this.getCustomDataIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getMimeType() == null ? 0 : this.getMimeType().hashCode());
        hashCode = 31 * hashCode + (this.getSensitiveData() == null ? 0 : this.getSensitiveData().hashCode());
        hashCode = 31 * hashCode + (this.getSizeClassified() == null ? 0 : this.getSizeClassified().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public ClassificationResult clone() {
        try {
            return (ClassificationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClassificationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

