/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideosignalingchannels.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.IceServer;
import java.util.List;

@SdkInternalApi
public class IceServerMarshaller {
    private static final MarshallingInfo<List> URIS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Uris").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").build();
    private static final MarshallingInfo<Integer> TTL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ttl").build();
    private static final IceServerMarshaller instance = new IceServerMarshaller();

    public static IceServerMarshaller getInstance() {
        return instance;
    }

    public void marshall(IceServer iceServer, ProtocolMarshaller protocolMarshaller) {
        if (iceServer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(iceServer.getUris(), URIS_BINDING);
            protocolMarshaller.marshall(iceServer.getUsername(), USERNAME_BINDING);
            protocolMarshaller.marshall(iceServer.getPassword(), PASSWORD_BINDING);
            protocolMarshaller.marshall(iceServer.getTtl(), TTL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

