/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideosignalingchannels;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.kinesisvideosignalingchannels.AmazonKinesisVideoSignalingChannels;
import com.amazonaws.services.kinesisvideosignalingchannels.AmazonKinesisVideoSignalingChannelsClientBuilder;
import com.amazonaws.services.kinesisvideosignalingchannels.model.AmazonKinesisVideoSignalingChannelsException;
import com.amazonaws.services.kinesisvideosignalingchannels.model.GetIceServerConfigRequest;
import com.amazonaws.services.kinesisvideosignalingchannels.model.GetIceServerConfigResult;
import com.amazonaws.services.kinesisvideosignalingchannels.model.SendAlexaOfferToMasterRequest;
import com.amazonaws.services.kinesisvideosignalingchannels.model.SendAlexaOfferToMasterResult;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.ClientLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.GetIceServerConfigRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.GetIceServerConfigResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.InvalidArgumentExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.InvalidClientExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.SendAlexaOfferToMasterRequestProtocolMarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.SendAlexaOfferToMasterResultJsonUnmarshaller;
import com.amazonaws.services.kinesisvideosignalingchannels.model.transform.SessionExpiredExceptionUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonKinesisVideoSignalingChannelsClient
extends AmazonWebServiceClient
implements AmazonKinesisVideoSignalingChannels {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonKinesisVideoSignalingChannels.class);
    private static final String DEFAULT_SIGNING_NAME = "kinesisvideo";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withExceptionUnmarshaller(InvalidArgumentExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientLimitExceededException").withExceptionUnmarshaller(ClientLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClientException").withExceptionUnmarshaller(InvalidClientExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SessionExpiredException").withExceptionUnmarshaller(SessionExpiredExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedException").withExceptionUnmarshaller(NotAuthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonKinesisVideoSignalingChannelsException.class));

    public static AmazonKinesisVideoSignalingChannelsClientBuilder builder() {
        return AmazonKinesisVideoSignalingChannelsClientBuilder.standard();
    }

    AmazonKinesisVideoSignalingChannelsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonKinesisVideoSignalingChannelsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("kinesisvideo.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/kinesisvideosignalingchannels/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/kinesisvideosignalingchannels/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetIceServerConfigResult getIceServerConfig(GetIceServerConfigRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetIceServerConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIceServerConfigResult executeGetIceServerConfig(GetIceServerConfigRequest getIceServerConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIceServerConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIceServerConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIceServerConfigRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getIceServerConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Kinesis Video Signaling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetIceServerConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetIceServerConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIceServerConfigResult getIceServerConfigResult = (GetIceServerConfigResult)response.getAwsResponse();
            return getIceServerConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendAlexaOfferToMasterResult sendAlexaOfferToMaster(SendAlexaOfferToMasterRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSendAlexaOfferToMaster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendAlexaOfferToMasterResult executeSendAlexaOfferToMaster(SendAlexaOfferToMasterRequest sendAlexaOfferToMasterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendAlexaOfferToMasterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendAlexaOfferToMasterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendAlexaOfferToMasterRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(sendAlexaOfferToMasterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Kinesis Video Signaling");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "SendAlexaOfferToMaster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SendAlexaOfferToMasterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendAlexaOfferToMasterResult sendAlexaOfferToMasterResult = (SendAlexaOfferToMasterResult)response.getAwsResponse();
            return sendAlexaOfferToMasterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

