/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.SalesforceConfiguration;
import java.util.List;

@SdkInternalApi
public class SalesforceConfigurationMarshaller {
    private static final MarshallingInfo<String> SERVERURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerUrl").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<List> STANDARDOBJECTCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardObjectConfigurations").build();
    private static final MarshallingInfo<StructuredPojo> KNOWLEDGEARTICLECONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KnowledgeArticleConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> CHATTERFEEDCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChatterFeedConfiguration").build();
    private static final MarshallingInfo<Boolean> CRAWLATTACHMENTS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlAttachments").build();
    private static final MarshallingInfo<StructuredPojo> STANDARDOBJECTATTACHMENTCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StandardObjectAttachmentConfiguration").build();
    private static final MarshallingInfo<List> INCLUDEATTACHMENTFILEPATTERNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeAttachmentFilePatterns").build();
    private static final MarshallingInfo<List> EXCLUDEATTACHMENTFILEPATTERNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeAttachmentFilePatterns").build();
    private static final SalesforceConfigurationMarshaller instance = new SalesforceConfigurationMarshaller();

    public static SalesforceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SalesforceConfiguration salesforceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (salesforceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(salesforceConfiguration.getServerUrl(), SERVERURL_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getStandardObjectConfigurations(), STANDARDOBJECTCONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getKnowledgeArticleConfiguration(), KNOWLEDGEARTICLECONFIGURATION_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getChatterFeedConfiguration(), CHATTERFEEDCONFIGURATION_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getCrawlAttachments(), CRAWLATTACHMENTS_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getStandardObjectAttachmentConfiguration(), STANDARDOBJECTATTACHMENTCONFIGURATION_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getIncludeAttachmentFilePatterns(), INCLUDEATTACHMENTFILEPATTERNS_BINDING);
            protocolMarshaller.marshall(salesforceConfiguration.getExcludeAttachmentFilePatterns(), EXCLUDEATTACHMENTFILEPATTERNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

