/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.S3DataSourceConfiguration;
import java.util.List;

@SdkInternalApi
public class S3DataSourceConfigurationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<List> INCLUSIONPREFIXES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InclusionPrefixes").build();
    private static final MarshallingInfo<List> INCLUSIONPATTERNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InclusionPatterns").build();
    private static final MarshallingInfo<List> EXCLUSIONPATTERNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusionPatterns").build();
    private static final MarshallingInfo<StructuredPojo> DOCUMENTSMETADATACONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentsMetadataConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> ACCESSCONTROLLISTCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessControlListConfiguration").build();
    private static final S3DataSourceConfigurationMarshaller instance = new S3DataSourceConfigurationMarshaller();

    public static S3DataSourceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DataSourceConfiguration s3DataSourceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3DataSourceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3DataSourceConfiguration.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(s3DataSourceConfiguration.getInclusionPrefixes(), INCLUSIONPREFIXES_BINDING);
            protocolMarshaller.marshall(s3DataSourceConfiguration.getInclusionPatterns(), INCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(s3DataSourceConfiguration.getExclusionPatterns(), EXCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(s3DataSourceConfiguration.getDocumentsMetadataConfiguration(), DOCUMENTSMETADATACONFIGURATION_BINDING);
            protocolMarshaller.marshall(s3DataSourceConfiguration.getAccessControlListConfiguration(), ACCESSCONTROLLISTCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

