/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.Facet;

@SdkInternalApi
public class FacetMarshaller {
    private static final MarshallingInfo<String> DOCUMENTATTRIBUTEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentAttributeKey").build();
    private static final FacetMarshaller instance = new FacetMarshaller();

    public static FacetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Facet facet, ProtocolMarshaller protocolMarshaller) {
        if (facet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(facet.getDocumentAttributeKey(), DOCUMENTATTRIBUTEKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

