/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.services.kendra.model.Document;
import com.amazonaws.services.kendra.model.DocumentAttribute;
import com.amazonaws.services.kendra.model.Principal;
import com.amazonaws.services.kendra.model.transform.DocumentAttributeJsonUnmarshaller;
import com.amazonaws.services.kendra.model.transform.PrincipalJsonUnmarshaller;
import com.amazonaws.services.kendra.model.transform.S3PathJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class DocumentJsonUnmarshaller
implements Unmarshaller<Document, JsonUnmarshallerContext> {
    private static DocumentJsonUnmarshaller instance;

    @Override
    public Document unmarshall(JsonUnmarshallerContext context) throws Exception {
        Document document = new Document();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    document.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    document.setTitle(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Blob", targetDepth)) {
                    context.nextToken();
                    document.setBlob(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("S3Path", targetDepth)) {
                    context.nextToken();
                    document.setS3Path(S3PathJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    document.setAttributes(new ListUnmarshaller<DocumentAttribute>(DocumentAttributeJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("AccessControlList", targetDepth)) {
                    context.nextToken();
                    document.setAccessControlList(new ListUnmarshaller<Principal>(PrincipalJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    context.nextToken();
                    document.setContentType(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return document;
    }

    public static DocumentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentJsonUnmarshaller();
        }
        return instance;
    }
}

