/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DatabaseConfiguration;

@SdkInternalApi
public class DatabaseConfigurationMarshaller {
    private static final MarshallingInfo<String> DATABASEENGINETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseEngineType").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> COLUMNCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> ACLCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AclConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SQLCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqlConfiguration").build();
    private static final DatabaseConfigurationMarshaller instance = new DatabaseConfigurationMarshaller();

    public static DatabaseConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatabaseConfiguration databaseConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (databaseConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(databaseConfiguration.getDatabaseEngineType(), DATABASEENGINETYPE_BINDING);
            protocolMarshaller.marshall(databaseConfiguration.getConnectionConfiguration(), CONNECTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(databaseConfiguration.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
            protocolMarshaller.marshall(databaseConfiguration.getColumnConfiguration(), COLUMNCONFIGURATION_BINDING);
            protocolMarshaller.marshall(databaseConfiguration.getAclConfiguration(), ACLCONFIGURATION_BINDING);
            protocolMarshaller.marshall(databaseConfiguration.getSqlConfiguration(), SQLCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

