/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.Highlight;
import com.amazonaws.services.kendra.model.transform.TextWithHighlightsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TextWithHighlights
implements Serializable,
Cloneable,
StructuredPojo {
    private String text;
    private List<Highlight> highlights;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public TextWithHighlights withText(String text) {
        this.setText(text);
        return this;
    }

    public List<Highlight> getHighlights() {
        return this.highlights;
    }

    public void setHighlights(Collection<Highlight> highlights) {
        if (highlights == null) {
            this.highlights = null;
            return;
        }
        this.highlights = new ArrayList<Highlight>(highlights);
    }

    public TextWithHighlights withHighlights(Highlight ... highlights) {
        if (this.highlights == null) {
            this.setHighlights(new ArrayList<Highlight>(highlights.length));
        }
        for (Highlight ele : highlights) {
            this.highlights.add(ele);
        }
        return this;
    }

    public TextWithHighlights withHighlights(Collection<Highlight> highlights) {
        this.setHighlights(highlights);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getHighlights() != null) {
            sb.append("Highlights: ").append(this.getHighlights());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextWithHighlights)) {
            return false;
        }
        TextWithHighlights other = (TextWithHighlights)obj;
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getHighlights() == null ^ this.getHighlights() == null) {
            return false;
        }
        return other.getHighlights() == null || other.getHighlights().equals(this.getHighlights());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getHighlights() == null ? 0 : this.getHighlights().hashCode());
        return hashCode;
    }

    public TextWithHighlights clone() {
        try {
            return (TextWithHighlights)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TextWithHighlightsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

