/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.SalesforceStandardObjectName;
import com.amazonaws.services.kendra.model.transform.SalesforceStandardObjectConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SalesforceStandardObjectConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String documentDataFieldName;
    private String documentTitleFieldName;
    private List<DataSourceToIndexFieldMapping> fieldMappings;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SalesforceStandardObjectConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public SalesforceStandardObjectConfiguration withName(SalesforceStandardObjectName name) {
        this.name = name.toString();
        return this;
    }

    public void setDocumentDataFieldName(String documentDataFieldName) {
        this.documentDataFieldName = documentDataFieldName;
    }

    public String getDocumentDataFieldName() {
        return this.documentDataFieldName;
    }

    public SalesforceStandardObjectConfiguration withDocumentDataFieldName(String documentDataFieldName) {
        this.setDocumentDataFieldName(documentDataFieldName);
        return this;
    }

    public void setDocumentTitleFieldName(String documentTitleFieldName) {
        this.documentTitleFieldName = documentTitleFieldName;
    }

    public String getDocumentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public SalesforceStandardObjectConfiguration withDocumentTitleFieldName(String documentTitleFieldName) {
        this.setDocumentTitleFieldName(documentTitleFieldName);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public SalesforceStandardObjectConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public SalesforceStandardObjectConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDocumentDataFieldName() != null) {
            sb.append("DocumentDataFieldName: ").append(this.getDocumentDataFieldName()).append(",");
        }
        if (this.getDocumentTitleFieldName() != null) {
            sb.append("DocumentTitleFieldName: ").append(this.getDocumentTitleFieldName()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceStandardObjectConfiguration)) {
            return false;
        }
        SalesforceStandardObjectConfiguration other = (SalesforceStandardObjectConfiguration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDocumentDataFieldName() == null ^ this.getDocumentDataFieldName() == null) {
            return false;
        }
        if (other.getDocumentDataFieldName() != null && !other.getDocumentDataFieldName().equals(this.getDocumentDataFieldName())) {
            return false;
        }
        if (other.getDocumentTitleFieldName() == null ^ this.getDocumentTitleFieldName() == null) {
            return false;
        }
        if (other.getDocumentTitleFieldName() != null && !other.getDocumentTitleFieldName().equals(this.getDocumentTitleFieldName())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        return other.getFieldMappings() == null || other.getFieldMappings().equals(this.getFieldMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentDataFieldName() == null ? 0 : this.getDocumentDataFieldName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentTitleFieldName() == null ? 0 : this.getDocumentTitleFieldName().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        return hashCode;
    }

    public SalesforceStandardObjectConfiguration clone() {
        try {
            return (SalesforceStandardObjectConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceStandardObjectConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

