/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.Order;
import com.amazonaws.services.kendra.model.transform.RelevanceMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Relevance
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean freshness;
    private Integer importance;
    private String duration;
    private String rankOrder;
    private Map<String, Integer> valueImportanceMap;

    public void setFreshness(Boolean freshness) {
        this.freshness = freshness;
    }

    public Boolean getFreshness() {
        return this.freshness;
    }

    public Relevance withFreshness(Boolean freshness) {
        this.setFreshness(freshness);
        return this;
    }

    public Boolean isFreshness() {
        return this.freshness;
    }

    public void setImportance(Integer importance) {
        this.importance = importance;
    }

    public Integer getImportance() {
        return this.importance;
    }

    public Relevance withImportance(Integer importance) {
        this.setImportance(importance);
        return this;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getDuration() {
        return this.duration;
    }

    public Relevance withDuration(String duration) {
        this.setDuration(duration);
        return this;
    }

    public void setRankOrder(String rankOrder) {
        this.rankOrder = rankOrder;
    }

    public String getRankOrder() {
        return this.rankOrder;
    }

    public Relevance withRankOrder(String rankOrder) {
        this.setRankOrder(rankOrder);
        return this;
    }

    public Relevance withRankOrder(Order rankOrder) {
        this.rankOrder = rankOrder.toString();
        return this;
    }

    public Map<String, Integer> getValueImportanceMap() {
        return this.valueImportanceMap;
    }

    public void setValueImportanceMap(Map<String, Integer> valueImportanceMap) {
        this.valueImportanceMap = valueImportanceMap;
    }

    public Relevance withValueImportanceMap(Map<String, Integer> valueImportanceMap) {
        this.setValueImportanceMap(valueImportanceMap);
        return this;
    }

    public Relevance addValueImportanceMapEntry(String key, Integer value) {
        if (null == this.valueImportanceMap) {
            this.valueImportanceMap = new HashMap<String, Integer>();
        }
        if (this.valueImportanceMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.valueImportanceMap.put(key, value);
        return this;
    }

    public Relevance clearValueImportanceMapEntries() {
        this.valueImportanceMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFreshness() != null) {
            sb.append("Freshness: ").append(this.getFreshness()).append(",");
        }
        if (this.getImportance() != null) {
            sb.append("Importance: ").append(this.getImportance()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getRankOrder() != null) {
            sb.append("RankOrder: ").append(this.getRankOrder()).append(",");
        }
        if (this.getValueImportanceMap() != null) {
            sb.append("ValueImportanceMap: ").append(this.getValueImportanceMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relevance)) {
            return false;
        }
        Relevance other = (Relevance)obj;
        if (other.getFreshness() == null ^ this.getFreshness() == null) {
            return false;
        }
        if (other.getFreshness() != null && !other.getFreshness().equals(this.getFreshness())) {
            return false;
        }
        if (other.getImportance() == null ^ this.getImportance() == null) {
            return false;
        }
        if (other.getImportance() != null && !other.getImportance().equals(this.getImportance())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getRankOrder() == null ^ this.getRankOrder() == null) {
            return false;
        }
        if (other.getRankOrder() != null && !other.getRankOrder().equals(this.getRankOrder())) {
            return false;
        }
        if (other.getValueImportanceMap() == null ^ this.getValueImportanceMap() == null) {
            return false;
        }
        return other.getValueImportanceMap() == null || other.getValueImportanceMap().equals(this.getValueImportanceMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFreshness() == null ? 0 : this.getFreshness().hashCode());
        hashCode = 31 * hashCode + (this.getImportance() == null ? 0 : this.getImportance().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getRankOrder() == null ? 0 : this.getRankOrder().hashCode());
        hashCode = 31 * hashCode + (this.getValueImportanceMap() == null ? 0 : this.getValueImportanceMap().hashCode());
        return hashCode;
    }

    public Relevance clone() {
        try {
            return (Relevance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RelevanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

