/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.DataSourceConfiguration;
import com.amazonaws.services.kendra.model.DataSourceType;
import com.amazonaws.services.kendra.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDataSourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String indexId;
    private String type;
    private DataSourceConfiguration configuration;
    private String description;
    private String schedule;
    private String roleArn;
    private List<Tag> tags;
    private String clientToken;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateDataSourceRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public CreateDataSourceRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateDataSourceRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateDataSourceRequest withType(DataSourceType type) {
        this.type = type.toString();
        return this;
    }

    public void setConfiguration(DataSourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public DataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public CreateDataSourceRequest withConfiguration(DataSourceConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateDataSourceRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public CreateDataSourceRequest withSchedule(String schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateDataSourceRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDataSourceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDataSourceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateDataSourceRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateDataSourceRequest clone() {
        return (CreateDataSourceRequest)super.clone();
    }
}

