/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.DataSourceSyncJobMetricTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDeleteDocumentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String indexId;
    private List<String> documentIdList;
    private DataSourceSyncJobMetricTarget dataSourceSyncJobMetricTarget;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public BatchDeleteDocumentRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public List<String> getDocumentIdList() {
        return this.documentIdList;
    }

    public void setDocumentIdList(Collection<String> documentIdList) {
        if (documentIdList == null) {
            this.documentIdList = null;
            return;
        }
        this.documentIdList = new ArrayList<String>(documentIdList);
    }

    public BatchDeleteDocumentRequest withDocumentIdList(String ... documentIdList) {
        if (this.documentIdList == null) {
            this.setDocumentIdList(new ArrayList<String>(documentIdList.length));
        }
        for (String ele : documentIdList) {
            this.documentIdList.add(ele);
        }
        return this;
    }

    public BatchDeleteDocumentRequest withDocumentIdList(Collection<String> documentIdList) {
        this.setDocumentIdList(documentIdList);
        return this;
    }

    public void setDataSourceSyncJobMetricTarget(DataSourceSyncJobMetricTarget dataSourceSyncJobMetricTarget) {
        this.dataSourceSyncJobMetricTarget = dataSourceSyncJobMetricTarget;
    }

    public DataSourceSyncJobMetricTarget getDataSourceSyncJobMetricTarget() {
        return this.dataSourceSyncJobMetricTarget;
    }

    public BatchDeleteDocumentRequest withDataSourceSyncJobMetricTarget(DataSourceSyncJobMetricTarget dataSourceSyncJobMetricTarget) {
        this.setDataSourceSyncJobMetricTarget(dataSourceSyncJobMetricTarget);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getDocumentIdList() != null) {
            sb.append("DocumentIdList: ").append(this.getDocumentIdList()).append(",");
        }
        if (this.getDataSourceSyncJobMetricTarget() != null) {
            sb.append("DataSourceSyncJobMetricTarget: ").append(this.getDataSourceSyncJobMetricTarget());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentRequest)) {
            return false;
        }
        BatchDeleteDocumentRequest other = (BatchDeleteDocumentRequest)obj;
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getDocumentIdList() == null ^ this.getDocumentIdList() == null) {
            return false;
        }
        if (other.getDocumentIdList() != null && !other.getDocumentIdList().equals(this.getDocumentIdList())) {
            return false;
        }
        if (other.getDataSourceSyncJobMetricTarget() == null ^ this.getDataSourceSyncJobMetricTarget() == null) {
            return false;
        }
        return other.getDataSourceSyncJobMetricTarget() == null || other.getDataSourceSyncJobMetricTarget().equals(this.getDataSourceSyncJobMetricTarget());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentIdList() == null ? 0 : this.getDocumentIdList().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceSyncJobMetricTarget() == null ? 0 : this.getDataSourceSyncJobMetricTarget().hashCode());
        return hashCode;
    }

    @Override
    public BatchDeleteDocumentRequest clone() {
        return (BatchDeleteDocumentRequest)super.clone();
    }
}

